/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.MergeRequest;

public class MergeRequestApi
extends AbstractApi {
    public MergeRequestApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<MergeRequest> getMergeRequests(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "merge_requests");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public MergeRequest getMergeRequest(Integer projectId, Integer mergeRequestId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "merge_request", mergeRequestId);
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest createMergeRequest(Integer projectId, String sourceBranch, String targetBranch, String title, String description, Integer assigneeId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Form formData = new Form();
        this.addFormParam(formData, "source_branch", sourceBranch, true);
        this.addFormParam(formData, "target_branch", targetBranch, true);
        this.addFormParam(formData, "title", title, true);
        this.addFormParam(formData, "description", description, false);
        this.addFormParam(formData, "assignee_id", assigneeId, false);
        Response response = this.post(Response.Status.CREATED, formData, "projects", projectId, "merge_requests");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest updateMergeRequest(Integer projectId, Integer mergeRequestId, String sourceBranch, String targetBranch, String title, String description, Integer assigneeId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("mergeRequestId cannot be null");
        }
        if (mergeRequestId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Form formData = new Form();
        this.addFormParam(formData, "source_branch", sourceBranch, false);
        this.addFormParam(formData, "target_branch", targetBranch, false);
        this.addFormParam(formData, "title", title, false);
        this.addFormParam(formData, "description", description, false);
        this.addFormParam(formData, "assignee_id", assigneeId, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "merge_request", mergeRequestId);
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }
}

