/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.utils.JacksonJsonEnumHelper;

public interface Constants {
    public static final String TOTAL_HEADER = "X-Total";
    public static final String TOTAL_PAGES_HEADER = "X-Total-Pages";
    public static final String PER_PAGE = "X-Per-Page";
    public static final String PAGE_HEADER = "X-Page";
    public static final String NEXT_PAGE_HEADER = "X-Next-Page";
    public static final String PREV_PAGE_HEADER = "X-Prev-Page";
    public static final String PER_PAGE_PARAM = "per_page";
    public static final String PAGE_PARAM = "page";

    public static enum ActionType {
        CREATED,
        UPDATED,
        CLOSED,
        REOPENED,
        PUSHED,
        COMMENTED,
        MERGED,
        JOINED,
        LEFT,
        DESTROYED,
        EXPIRED,
        REMOVED;

        private static JacksonJsonEnumHelper<ActionType> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<ActionType>(ActionType.class);
        }

        @JsonCreator
        public static ActionType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum ApplicationScope {
        API,
        READ_USER,
        SUDO,
        READ_REPOSITORY,
        OPENID,
        PROFILE,
        EMAIL;

        private static JacksonJsonEnumHelper<ApplicationScope> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<ApplicationScope>(ApplicationScope.class);
        }

        @JsonCreator
        public static ApplicationScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum ArchiveFormat {
        BZ2,
        TAR,
        TAR_BZ2,
        TAR_GZ,
        TB2,
        TBZ,
        TBZ2,
        ZIP;

        private final String value = this.name().toLowerCase().replace('_', '.');
        private static Map<String, ArchiveFormat> valuesMap;

        static {
            valuesMap = new HashMap<String, ArchiveFormat>(8);
            ArchiveFormat[] archiveFormatArray = ArchiveFormat.values();
            int n = archiveFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArchiveFormat archiveFormat = archiveFormatArray[n2];
                valuesMap.put(archiveFormat.value, archiveFormat);
                ++n2;
            }
        }

        public static ArchiveFormat forValue(String value) throws GitLabApiException {
            if (value == null || value.trim().isEmpty()) {
                return null;
            }
            ArchiveFormat archiveFormat = valuesMap.get(value);
            if (archiveFormat != null) {
                return archiveFormat;
            }
            throw new GitLabApiException("Invalid format! Options are tar.gz, tar.bz2, tbz, tbz2, tb2, bz2, tar, and zip.");
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum AutoDevopsDeployStrategy {
        CONTINUOUS,
        MANUAL,
        TIMED_INCREMENTAL;

        private static JacksonJsonEnumHelper<AutoDevopsDeployStrategy> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<AutoDevopsDeployStrategy>(AutoDevopsDeployStrategy.class);
        }

        @JsonCreator
        public static AutoDevopsDeployStrategy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum BuildGitStrategy {
        FETCH,
        CLONE;

        private static JacksonJsonEnumHelper<BuildGitStrategy> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<BuildGitStrategy>(BuildGitStrategy.class);
        }

        @JsonCreator
        public static BuildGitStrategy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum CommitBuildState {
        PENDING,
        RUNNING,
        SUCCESS,
        FAILED,
        CANCELED;

        private static JacksonJsonEnumHelper<CommitBuildState> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<CommitBuildState>(CommitBuildState.class);
        }

        @JsonCreator
        public static CommitBuildState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum DeployTokenScope {
        READ_REPOSITORY,
        READ_REGISTRY;

        private static JacksonJsonEnumHelper<DeployTokenScope> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<DeployTokenScope>(DeployTokenScope.class);
        }

        @JsonCreator
        public static DeployTokenScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum DeploymentOrderBy {
        ID,
        IID,
        CREATED_AT,
        UPDATED_AT,
        REF;

        private static JacksonJsonEnumHelper<DeploymentOrderBy> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<DeploymentOrderBy>(DeploymentOrderBy.class);
        }

        @JsonCreator
        public static DeploymentOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum DeploymentStatus {
        CREATED,
        RUNNING,
        SUCCESS,
        FAILED,
        CANCELED;

        private static JacksonJsonEnumHelper<DeploymentStatus> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<DeploymentStatus>(DeploymentStatus.class);
        }

        @JsonCreator
        public static DeploymentStatus forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum Encoding {
        TEXT,
        BASE64;

        private static JacksonJsonEnumHelper<Encoding> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<Encoding>(Encoding.class);
        }

        @JsonCreator
        public static Encoding forValue(String value) {
            return enumHelper.forValue(value != null ? value.toLowerCase() : value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum EpicOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static JacksonJsonEnumHelper<EpicOrderBy> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<EpicOrderBy>(EpicOrderBy.class);
        }

        @JsonCreator
        public static EpicOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum GroupOrderBy {
        NAME,
        PATH,
        ID;

        private static JacksonJsonEnumHelper<GroupOrderBy> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<GroupOrderBy>(GroupOrderBy.class);
        }

        @JsonCreator
        public static GroupOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum GroupSearchScope {
        PROJECTS,
        ISSUES,
        MERGE_REQUESTS,
        MILESTONES,
        USERS;

        private static JacksonJsonEnumHelper<GroupSearchScope> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<GroupSearchScope>(GroupSearchScope.class);
        }

        @JsonCreator
        public static GroupSearchScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum ImpersonationState {
        ALL,
        ACTIVE,
        INACTIVE;

        private static JacksonJsonEnumHelper<ImpersonationState> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<ImpersonationState>(ImpersonationState.class);
        }

        @JsonCreator
        public static ImpersonationState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum IssueOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static JacksonJsonEnumHelper<IssueOrderBy> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueOrderBy>(IssueOrderBy.class);
        }

        @JsonCreator
        public static IssueOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum IssueScope {
        CREATED_BY_ME,
        ASSIGNED_TO_ME,
        ALL;

        private static JacksonJsonEnumHelper<IssueScope> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueScope>(IssueScope.class);
        }

        @JsonCreator
        public static IssueScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum IssueState {
        OPENED,
        CLOSED,
        REOPENED;

        private static JacksonJsonEnumHelper<IssueState> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueState>(IssueState.class);
        }

        @JsonCreator
        public static IssueState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum JobScope {
        CREATED,
        PENDING,
        RUNNING,
        FAILED,
        SUCCESS,
        CANCELED,
        SKIPPED,
        MANUAL;

        private static JacksonJsonEnumHelper<JobScope> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<JobScope>(JobScope.class);
        }

        @JsonCreator
        public static JobScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum LineType {
        OLD,
        NEW;

        private static JacksonJsonEnumHelper<LineType> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<LineType>(LineType.class);
        }

        @JsonCreator
        public static LineType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum MergeRequestOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static JacksonJsonEnumHelper<MergeRequestOrderBy> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestOrderBy>(MergeRequestOrderBy.class);
        }

        @JsonCreator
        public static MergeRequestOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum MergeRequestScope {
        CREATED_BY_ME,
        ASSIGNED_TO_ME,
        ALL;

        private static JacksonJsonEnumHelper<MergeRequestScope> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestScope>(MergeRequestScope.class);
        }

        @JsonCreator
        public static MergeRequestScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum MergeRequestSearchIn {
        TITLE,
        DESCRIPTION;

        private static JacksonJsonEnumHelper<MergeRequestSearchIn> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestSearchIn>(MergeRequestSearchIn.class);
        }

        @JsonCreator
        public static MergeRequestSearchIn forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum MergeRequestState {
        OPENED,
        CLOSED,
        LOCKED,
        MERGED,
        ALL;

        private static JacksonJsonEnumHelper<MergeRequestState> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestState>(MergeRequestState.class);
        }

        @JsonCreator
        public static MergeRequestState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum MilestoneState {
        ACTIVE,
        CLOSED,
        ACTIVATE,
        CLOSE;

        private static JacksonJsonEnumHelper<MilestoneState> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<MilestoneState>(MilestoneState.class);
        }

        @JsonCreator
        public static MilestoneState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum PipelineOrderBy {
        ID,
        STATUS,
        REF,
        UPDATED_AT,
        USER_ID;

        private static JacksonJsonEnumHelper<PipelineOrderBy> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<PipelineOrderBy>(PipelineOrderBy.class);
        }

        @JsonCreator
        public static PipelineOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum PipelineScope {
        RUNNING,
        PENDING,
        FINISHED,
        BRANCHES,
        TAGS;

        private static JacksonJsonEnumHelper<PipelineScope> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<PipelineScope>(PipelineScope.class);
        }

        @JsonCreator
        public static PipelineScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum ProjectOrderBy {
        ID,
        NAME,
        PATH,
        CREATED_AT,
        UPDATED_AT,
        LAST_ACTIVITY_AT;

        private static JacksonJsonEnumHelper<ProjectOrderBy> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectOrderBy>(ProjectOrderBy.class);
        }

        @JsonCreator
        public static ProjectOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum ProjectSearchScope {
        BLOBS,
        COMMITS,
        ISSUES,
        MERGE_REQUESTS,
        MILESTONES,
        NOTES,
        WIKI_BLOBS,
        USERS;

        private static JacksonJsonEnumHelper<ProjectSearchScope> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectSearchScope>(ProjectSearchScope.class);
        }

        @JsonCreator
        public static ProjectSearchScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum SearchScope {
        PROJECTS,
        ISSUES,
        MERGE_REQUESTS,
        MILESTONES,
        SNIPPET_TITLES,
        SNIPPET_BLOBS,
        USERS,
        BLOBS,
        COMMITS,
        WIKI_BLOBS;

        private static JacksonJsonEnumHelper<SearchScope> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<SearchScope>(SearchScope.class);
        }

        @JsonCreator
        public static SearchScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum SortOrder {
        ASC,
        DESC;

        private static JacksonJsonEnumHelper<SortOrder> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<SortOrder>(SortOrder.class);
        }

        @JsonCreator
        public static SortOrder forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum SquashOption {
        NEVER,
        ALWAYS,
        DEFAULT_ON,
        DEFAULT_OFF;

        private static JacksonJsonEnumHelper<SquashOption> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<SquashOption>(SquashOption.class);
        }

        @JsonCreator
        public static SquashOption forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum StateEvent {
        CLOSE,
        REOPEN;

        private static JacksonJsonEnumHelper<StateEvent> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<StateEvent>(StateEvent.class);
        }

        @JsonCreator
        public static StateEvent forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum TagOrderBy {
        NAME,
        UPDATED;

        private static JacksonJsonEnumHelper<TagOrderBy> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<TagOrderBy>(TagOrderBy.class);
        }

        @JsonCreator
        public static TagOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum TargetType {
        ISSUE,
        MILESTONE,
        MERGE_REQUEST,
        NOTE,
        PROJECT,
        SNIPPET,
        USER;

        private static JacksonJsonEnumHelper<TargetType> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<TargetType>(TargetType.class, true, false, true);
        }

        @JsonCreator
        public static TargetType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum TodoAction {
        ASSIGNED,
        MENTIONED,
        BUILD_FAILED,
        MARKED,
        APPROVAL_REQUIRED,
        UNMERGEABLE,
        DIRECTLY_ADDRESSED;

        private static JacksonJsonEnumHelper<TodoAction> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoAction>(TodoAction.class);
        }

        @JsonCreator
        public static TodoAction forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum TodoState {
        PENDING,
        DONE;

        private static JacksonJsonEnumHelper<TodoState> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoState>(TodoState.class);
        }

        @JsonCreator
        public static TodoState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum TodoType {
        ISSUE,
        MERGE_REQUEST;

        private static JacksonJsonEnumHelper<TodoType> enumHelper;

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoType>(TodoType.class, true, true);
        }

        @JsonCreator
        public static TodoType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }
    }

    public static enum TokenType {
        ACCESS,
        OAUTH2_ACCESS,
        PRIVATE;

    }
}

