/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.utils.JacksonJsonEnumHelper;

public interface Constants {
    public static final String TOTAL_HEADER = "X-Total";
    public static final String TOTAL_PAGES_HEADER = "X-Total-Pages";
    public static final String PER_PAGE = "X-Per-Page";
    public static final String PAGE_HEADER = "X-Page";
    public static final String NEXT_PAGE_HEADER = "X-Next-Page";
    public static final String PREV_PAGE_HEADER = "X-Prev-Page";
    public static final String PER_PAGE_PARAM = "per_page";
    public static final String PAGE_PARAM = "page";

    public static enum DeployTokenScope {
        READ_REPOSITORY,
        READ_REGISTRY;

        private static JacksonJsonEnumHelper<DeployTokenScope> enumHelper;

        @JsonCreator
        public static DeployTokenScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<DeployTokenScope>(DeployTokenScope.class);
        }
    }

    public static enum DeploymentStatus {
        CREATED,
        RUNNING,
        SUCCESS,
        FAILED,
        CANCELED;

        private static JacksonJsonEnumHelper<DeploymentStatus> enumHelper;

        @JsonCreator
        public static DeploymentStatus forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<DeploymentStatus>(DeploymentStatus.class);
        }
    }

    public static enum TodoType {
        ISSUE,
        MERGE_REQUEST;

        private static JacksonJsonEnumHelper<TodoType> enumHelper;

        @JsonCreator
        public static TodoType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoType>(TodoType.class, true, true);
        }
    }

    public static enum TodoState {
        PENDING,
        DONE;

        private static JacksonJsonEnumHelper<TodoState> enumHelper;

        @JsonCreator
        public static TodoState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoState>(TodoState.class);
        }
    }

    public static enum TodoAction {
        ASSIGNED,
        MENTIONED,
        BUILD_FAILED,
        MARKED,
        APPROVAL_REQUIRED,
        UNMERGEABLE,
        DIRECTLY_ADDRESSED;

        private static JacksonJsonEnumHelper<TodoAction> enumHelper;

        @JsonCreator
        public static TodoAction forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoAction>(TodoAction.class);
        }
    }

    public static enum ProjectSearchScope {
        BLOBS,
        COMMITS,
        ISSUES,
        MERGE_REQUESTS,
        MILESTONES,
        NOTES,
        WIKI_BLOBS,
        USERS;

        private static JacksonJsonEnumHelper<ProjectSearchScope> enumHelper;

        @JsonCreator
        public static ProjectSearchScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectSearchScope>(ProjectSearchScope.class);
        }
    }

    public static enum GroupSearchScope {
        PROJECTS,
        ISSUES,
        MERGE_REQUESTS,
        MILESTONES,
        USERS;

        private static JacksonJsonEnumHelper<GroupSearchScope> enumHelper;

        @JsonCreator
        public static GroupSearchScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<GroupSearchScope>(GroupSearchScope.class);
        }
    }

    public static enum SearchScope {
        PROJECTS,
        ISSUES,
        MERGE_REQUESTS,
        MILESTONES,
        SNIPPET_TITLES,
        SNIPPET_BLOBS,
        USERS,
        BLOBS,
        COMMITS,
        WIKI_BLOBS;

        private static JacksonJsonEnumHelper<SearchScope> enumHelper;

        @JsonCreator
        public static SearchScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<SearchScope>(SearchScope.class);
        }
    }

    public static enum ApplicationScope {
        API,
        READ_USER,
        SUDO,
        READ_REPOSITORY,
        OPENID,
        PROFILE,
        EMAIL;

        private static JacksonJsonEnumHelper<ApplicationScope> enumHelper;

        @JsonCreator
        public static ApplicationScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ApplicationScope>(ApplicationScope.class);
        }
    }

    public static enum CommitBuildState {
        PENDING,
        RUNNING,
        SUCCESS,
        FAILED,
        CANCELED;

        private static JacksonJsonEnumHelper<CommitBuildState> enumHelper;

        @JsonCreator
        public static CommitBuildState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<CommitBuildState>(CommitBuildState.class);
        }
    }

    public static enum ArchiveFormat {
        BZ2,
        TAR,
        TAR_BZ2,
        TAR_GZ,
        TB2,
        TBZ,
        TBZ2,
        ZIP;

        private final String value = this.name().toLowerCase().replace('_', '.');
        private static Map<String, ArchiveFormat> valuesMap;

        public static ArchiveFormat forValue(String value) throws GitLabApiException {
            if (value == null || value.trim().isEmpty()) {
                return null;
            }
            ArchiveFormat archiveFormat = valuesMap.get(value);
            if (archiveFormat != null) {
                return archiveFormat;
            }
            throw new GitLabApiException("Invalid format! Options are tar.gz, tar.bz2, tbz, tbz2, tb2, bz2, tar, and zip.");
        }

        public String toString() {
            return this.value;
        }

        static {
            valuesMap = new HashMap<String, ArchiveFormat>(8);
            for (ArchiveFormat archiveFormat : ArchiveFormat.values()) {
                valuesMap.put(archiveFormat.value, archiveFormat);
            }
        }
    }

    public static enum ImpersonationState {
        ALL,
        ACTIVE,
        INACTIVE;

        private static JacksonJsonEnumHelper<ImpersonationState> enumHelper;

        @JsonCreator
        public static ImpersonationState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ImpersonationState>(ImpersonationState.class);
        }
    }

    public static enum LineType {
        OLD,
        NEW;

        private static JacksonJsonEnumHelper<LineType> enumHelper;

        @JsonCreator
        public static LineType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<LineType>(LineType.class);
        }
    }

    public static enum TargetType {
        ISSUE,
        MILESTONE,
        MERGE_REQUEST,
        NOTE,
        PROJECT,
        SNIPPET,
        USER;

        private static JacksonJsonEnumHelper<TargetType> enumHelper;

        @JsonCreator
        public static TargetType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TargetType>(TargetType.class, true, true);
        }
    }

    public static enum ActionType {
        CREATED,
        UPDATED,
        CLOSED,
        REOPENED,
        PUSHED,
        COMMENTED,
        MERGED,
        JOINED,
        LEFT,
        DESTROYED,
        EXPIRED,
        REMOVED;

        private static JacksonJsonEnumHelper<ActionType> enumHelper;

        @JsonCreator
        public static ActionType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ActionType>(ActionType.class);
        }
    }

    public static enum MilestoneState {
        ACTIVE,
        CLOSED,
        ACTIVATE,
        CLOSE;

        private static JacksonJsonEnumHelper<MilestoneState> enumHelper;

        @JsonCreator
        public static MilestoneState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MilestoneState>(MilestoneState.class);
        }
    }

    public static enum IssueState {
        OPENED,
        CLOSED,
        REOPENED;

        private static JacksonJsonEnumHelper<IssueState> enumHelper;

        @JsonCreator
        public static IssueState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueState>(IssueState.class);
        }
    }

    public static enum StateEvent {
        CLOSE,
        REOPEN;

        private static JacksonJsonEnumHelper<StateEvent> enumHelper;

        @JsonCreator
        public static StateEvent forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<StateEvent>(StateEvent.class);
        }
    }

    public static enum MergeRequestSearchIn {
        TITLE,
        DESCRIPTION;

        private static JacksonJsonEnumHelper<MergeRequestSearchIn> enumHelper;

        @JsonCreator
        public static MergeRequestSearchIn forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestSearchIn>(MergeRequestSearchIn.class);
        }
    }

    public static enum MergeRequestState {
        OPENED,
        CLOSED,
        LOCKED,
        MERGED,
        ALL;

        private static JacksonJsonEnumHelper<MergeRequestState> enumHelper;

        @JsonCreator
        public static MergeRequestState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestState>(MergeRequestState.class);
        }
    }

    public static enum MergeRequestScope {
        CREATED_BY_ME,
        ASSIGNED_TO_ME,
        ALL;

        private static JacksonJsonEnumHelper<MergeRequestScope> enumHelper;

        @JsonCreator
        public static MergeRequestScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestScope>(MergeRequestScope.class);
        }
    }

    public static enum IssueScope {
        CREATED_BY_ME,
        ASSIGNED_TO_ME,
        ALL;

        private static JacksonJsonEnumHelper<IssueScope> enumHelper;

        @JsonCreator
        public static IssueScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueScope>(IssueScope.class);
        }
    }

    public static enum JobScope {
        CREATED,
        PENDING,
        RUNNING,
        FAILED,
        SUCCESS,
        CANCELED,
        SKIPPED,
        MANUAL;

        private static JacksonJsonEnumHelper<JobScope> enumHelper;

        @JsonCreator
        public static JobScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<JobScope>(JobScope.class);
        }
    }

    public static enum PipelineScope {
        RUNNING,
        PENDING,
        FINISHED,
        BRANCHES,
        TAGS;

        private static JacksonJsonEnumHelper<PipelineScope> enumHelper;

        @JsonCreator
        public static PipelineScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<PipelineScope>(PipelineScope.class);
        }
    }

    public static enum TagOrderBy {
        NAME,
        UPDATED;

        private static JacksonJsonEnumHelper<TagOrderBy> enumHelper;

        @JsonCreator
        public static TagOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TagOrderBy>(TagOrderBy.class);
        }
    }

    public static enum GroupOrderBy {
        NAME,
        PATH,
        ID;

        private static JacksonJsonEnumHelper<GroupOrderBy> enumHelper;

        @JsonCreator
        public static GroupOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<GroupOrderBy>(GroupOrderBy.class);
        }
    }

    public static enum MergeRequestOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static JacksonJsonEnumHelper<MergeRequestOrderBy> enumHelper;

        @JsonCreator
        public static MergeRequestOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestOrderBy>(MergeRequestOrderBy.class);
        }
    }

    public static enum PipelineOrderBy {
        ID,
        STATUS,
        REF,
        USER_ID;

        private static JacksonJsonEnumHelper<PipelineOrderBy> enumHelper;

        @JsonCreator
        public static PipelineOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<PipelineOrderBy>(PipelineOrderBy.class);
        }
    }

    public static enum ProjectOrderBy {
        ID,
        NAME,
        PATH,
        CREATED_AT,
        UPDATED_AT,
        LAST_ACTIVITY_AT;

        private static JacksonJsonEnumHelper<ProjectOrderBy> enumHelper;

        @JsonCreator
        public static ProjectOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectOrderBy>(ProjectOrderBy.class);
        }
    }

    public static enum IssueOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static JacksonJsonEnumHelper<IssueOrderBy> enumHelper;

        @JsonCreator
        public static IssueOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueOrderBy>(IssueOrderBy.class);
        }
    }

    public static enum EpicOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static JacksonJsonEnumHelper<EpicOrderBy> enumHelper;

        @JsonCreator
        public static EpicOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<EpicOrderBy>(EpicOrderBy.class);
        }
    }

    public static enum SortOrder {
        ASC,
        DESC;

        private static JacksonJsonEnumHelper<SortOrder> enumHelper;

        @JsonCreator
        public static SortOrder forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<SortOrder>(SortOrder.class);
        }
    }

    public static enum Encoding {
        TEXT,
        BASE64;

        private static JacksonJsonEnumHelper<Encoding> enumHelper;

        @JsonCreator
        public static Encoding forValue(String value) {
            return enumHelper.forValue(value != null ? value.toLowerCase() : value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<Encoding>(Encoding.class);
        }
    }

    public static enum TokenType {
        ACCESS,
        OAUTH2_ACCESS,
        PRIVATE;

    }
}

