/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.MergeRequestFilter;
import org.gitlab4j.api.models.MergeRequestParams;
import org.gitlab4j.api.models.Participant;

public class MergeRequestApi
extends AbstractApi {
    public MergeRequestApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<MergeRequest> getMergeRequests(MergeRequestFilter filter) throws GitLabApiException {
        return this.getMergeRequests(filter, this.getDefaultPerPage()).all();
    }

    public List<MergeRequest> getMergeRequests(MergeRequestFilter filter, int page, int perPage) throws GitLabApiException {
        Response response;
        MultivaluedMap queryParams;
        MultivaluedMap multivaluedMap = queryParams = filter != null ? filter.getQueryParams(page, perPage).asMap() : this.getPageQueryParams(page, perPage);
        if (filter != null && filter.getProjectId() != null && filter.getProjectId() > 0 || filter.getIids() != null && filter.getIids().size() > 0) {
            if (filter.getProjectId() == null || filter.getProjectId() == 0) {
                throw new RuntimeException("project ID cannot be null or 0");
            }
            response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)queryParams, "projects", filter.getProjectId(), "merge_requests");
        } else {
            response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)queryParams, "merge_requests");
        }
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public Pager<MergeRequest> getMergeRequests(MergeRequestFilter filter, int itemsPerPage) throws GitLabApiException {
        MultivaluedMap queryParams;
        MultivaluedMap multivaluedMap = queryParams = filter != null ? filter.getQueryParams().asMap() : null;
        if (filter != null && filter.getProjectId() != null && filter.getProjectId() > 0 || filter.getIids() != null && filter.getIids().size() > 0) {
            if (filter.getProjectId() == null || filter.getProjectId() == 0) {
                throw new RuntimeException("project ID cannot be null or 0");
            }
            return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, (MultivaluedMap<String, String>)queryParams, "projects", filter.getProjectId(), "merge_requests");
        }
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, (MultivaluedMap<String, String>)queryParams, "merge_requests");
    }

    public Stream<MergeRequest> getMergeRequestsStream(MergeRequestFilter filter) throws GitLabApiException {
        return this.getMergeRequests(filter, this.getDefaultPerPage()).stream();
    }

    public List<MergeRequest> getMergeRequests(Object projectIdOrPath) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<MergeRequest> getMergeRequests(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public Pager<MergeRequest> getMergeRequests(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests");
    }

    public Stream<MergeRequest> getMergeRequestsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<MergeRequest> getMergeRequests(Object projectIdOrPath, Constants.MergeRequestState state) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, state, this.getDefaultPerPage()).all();
    }

    public List<MergeRequest> getMergeRequests(Object projectIdOrPath, Constants.MergeRequestState state, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public Pager<MergeRequest> getMergeRequests(Object projectIdOrPath, Constants.MergeRequestState state, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state);
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests");
    }

    public Stream<MergeRequest> getMergeRequestsStream(Object projectIdOrPath, Constants.MergeRequestState state) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, state, this.getDefaultPerPage()).stream();
    }

    public MergeRequest getMergeRequest(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid);
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public Optional<MergeRequest> getOptionalMergeRequest(Object projectIdOrPath, Integer mergeRequestIid) {
        try {
            return Optional.ofNullable(this.getMergeRequest(projectIdOrPath, mergeRequestIid));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<Commit> getCommits(Object projectIdOrPath, int mergeRequestIid) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public List<Commit> getCommits(Object projectIdOrPath, int mergeRequestIid, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("owned", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "commits");
        return (List)response.readEntity((GenericType)new GenericType<List<Commit>>(){});
    }

    public Pager<Commit> getCommits(Object projectIdOrPath, int mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Commit>(this, Commit.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "commits");
    }

    public Stream<Commit> getCommitsStream(Object projectIdOrPath, int mergeRequestIid) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).stream();
    }

    public MergeRequest createMergeRequest(Object projectIdOrPath, MergeRequestParams params) throws GitLabApiException {
        GitLabApiForm form = params.getForm(true);
        Response response = this.post(Response.Status.CREATED, (Form)form, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests"});
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest createMergeRequest(Object projectIdOrPath, String sourceBranch, String targetBranch, String title, String description, Integer assigneeId, Integer targetProjectId, String[] labels, Integer milestoneId, Boolean removeSourceBranch, Boolean squash) throws GitLabApiException {
        MergeRequestParams params = new MergeRequestParams().withSourceBranch(sourceBranch).withTargetBranch(targetBranch).withTitle(title).withDescription(description).withAssigneeId(assigneeId).withTargetProjectId(targetProjectId).withLabels(labels).withMilestoneId(milestoneId).withRemoveSourceBranch(removeSourceBranch).withSquash(squash);
        return this.createMergeRequest(projectIdOrPath, params);
    }

    public MergeRequest createMergeRequest(Object projectIdOrPath, String sourceBranch, String targetBranch, String title, String description, Integer assigneeId, Integer targetProjectId, String[] labels, Integer milestoneId, Boolean removeSourceBranch) throws GitLabApiException {
        MergeRequestParams params = new MergeRequestParams().withSourceBranch(sourceBranch).withTargetBranch(targetBranch).withTitle(title).withDescription(description).withAssigneeId(assigneeId).withTargetProjectId(targetProjectId).withLabels(labels).withMilestoneId(milestoneId).withRemoveSourceBranch(removeSourceBranch);
        return this.createMergeRequest(projectIdOrPath, params);
    }

    public MergeRequest createMergeRequest(Object projectIdOrPath, String sourceBranch, String targetBranch, String title, String description, Integer assigneeId) throws GitLabApiException {
        MergeRequestParams params = new MergeRequestParams().withSourceBranch(sourceBranch).withTargetBranch(targetBranch).withTitle(title).withDescription(description).withAssigneeId(assigneeId);
        return this.createMergeRequest(projectIdOrPath, params);
    }

    public MergeRequest updateMergeRequest(Object projectIdOrPath, Integer mergeRequestIid, MergeRequestParams params) throws GitLabApiException {
        GitLabApiForm form = params.getForm(false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid);
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest updateMergeRequest(Object projectIdOrPath, Integer mergeRequestIid, String targetBranch, String title, Integer assigneeId, String description, Constants.StateEvent stateEvent, String labels, Integer milestoneId, Boolean removeSourceBranch, Boolean squash, Boolean discussionLocked, Boolean allowCollaboration) throws GitLabApiException {
        String[] labelsArray = null;
        if (labels != null) {
            labelsArray = labels.split(",", -1);
        }
        MergeRequestParams params = new MergeRequestParams().withTargetBranch(targetBranch).withTitle(title).withAssigneeId(assigneeId).withDescription(description).withStateEvent(stateEvent).withLabels(labelsArray).withMilestoneId(milestoneId).withRemoveSourceBranch(removeSourceBranch).withDiscussionLocked(discussionLocked).withAllowCollaboration(allowCollaboration).withSquash(squash);
        return this.updateMergeRequest(projectIdOrPath, mergeRequestIid, params);
    }

    public void deleteMergeRequest(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid);
    }

    public MergeRequest acceptMergeRequest(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        return this.acceptMergeRequest(projectIdOrPath, mergeRequestIid, null, null, null, null);
    }

    public MergeRequest acceptMergeRequest(Object projectIdOrPath, Integer mergeRequestIid, String mergeCommitMessage, Boolean shouldRemoveSourceBranch, Boolean mergeWhenPipelineSucceeds) throws GitLabApiException {
        return this.acceptMergeRequest(projectIdOrPath, mergeRequestIid, mergeCommitMessage, shouldRemoveSourceBranch, mergeWhenPipelineSucceeds, null);
    }

    public MergeRequest acceptMergeRequest(Object projectIdOrPath, Integer mergeRequestIid, String mergeCommitMessage, Boolean shouldRemoveSourceBranch, Boolean mergeWhenPipelineSucceeds, String sha) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("merge_commit_message", mergeCommitMessage).withParam("should_remove_source_branch", shouldRemoveSourceBranch).withParam(this.isApiVersion(GitLabApi.ApiVersion.V3) ? "merge_when_build_succeeds" : "merge_when_pipeline_succeeds", mergeWhenPipelineSucceeds).withParam("sha", sha);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "merge");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest cancelMergeRequest(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response response = this.put(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "cancel_merge_when_pipeline_succeeds");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest getMergeRequestApprovals(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "approvals");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest approveMergeRequest(Object projectIdOrPath, Integer mergeRequestIid, String sha) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "approve"});
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest unapproveMergeRequest(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response response = this.post(Response.Status.OK, (Form)null, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "unapprove"});
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest getMergeRequestChanges(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "changes");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public List<Participant> getParticipants(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        return this.getParticipants(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public List<Participant> getParticipants(Object projectIdOrPath, Integer mergeRequestIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "participants");
        return (List)response.readEntity((GenericType)new GenericType<List<Participant>>(){});
    }

    public Pager<Participant> getParticipants(Object projectIdOrPath, Integer mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Participant>(this, Participant.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "participants");
    }

    public Stream<Participant> getParticipantsStream(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        return this.getParticipants(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).stream();
    }

    public List<Issue> getClosesIssues(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        return this.getClosesIssues(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public List<Issue> getClosesIssues(Object projectIdOrPath, Integer mergeRequestIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "closes_issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    public Pager<Issue> getClosesIssues(Object projectIdOrPath, Integer mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Issue>(this, Issue.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "closes_issues");
    }

    public Stream<Issue> getClosesIssuesStream(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        return this.getClosesIssues(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).stream();
    }
}

