/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.services.ExternalWikiService;
import org.gitlab4j.api.services.HipChatService;
import org.gitlab4j.api.services.JiraService;
import org.gitlab4j.api.services.SlackService;

public class ServicesApi
extends AbstractApi {
    public ServicesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public void setGitLabCI(Object projectIdOrPath, String token, String projectCIUrl) throws GitLabApiException {
        Form formData = new Form();
        formData.param("token", token);
        formData.param("project_url", projectCIUrl);
        this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "gitlab-ci");
    }

    public void deleteGitLabCI(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "gitlab-ci");
    }

    public HipChatService getHipChatService(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "hipchat");
        return (HipChatService)response.readEntity(HipChatService.class);
    }

    public HipChatService updateHipChatService(Object projectIdOrPath, HipChatService hipChat) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("push_events", hipChat.getPushEvents()).withParam("issues_events", hipChat.getIssuesEvents()).withParam("confidential_issues_events", hipChat.getConfidentialIssuesEvents()).withParam("merge_requests_events", hipChat.getMergeRequestsEvents()).withParam("tag_push_events", hipChat.getTagPushEvents()).withParam("note_events", hipChat.getNoteEvents()).withParam("confidential_note_events", hipChat.getConfidentialNoteEvents()).withParam("pipeline_events", hipChat.getPipelineEvents()).withParam("token", hipChat.getToken(), true).withParam("color", hipChat.getColor()).withParam("notify", hipChat.getNotify()).withParam("room", hipChat.getRoom()).withParam("api_version", hipChat.getApiVersion()).withParam("server", hipChat.getServer()).withParam("notify_only_broken_pipelines", hipChat.getNotifyOnlyBrokenPipelines());
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "hipchat");
        return (HipChatService)response.readEntity(HipChatService.class);
    }

    public void setHipChat(Object projectIdOrPath, String token, String room, String server) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("token", token).withParam("room", room).withParam("server", server);
        this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "hipchat");
    }

    public void deleteHipChat(Object projectIdOrPath) throws GitLabApiException {
        this.deleteHipChatService(projectIdOrPath);
    }

    public void deleteHipChatService(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "hipchat");
    }

    public SlackService getSlackService(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "slack");
        return (SlackService)response.readEntity(SlackService.class);
    }

    public SlackService updateSlackService(Object projectIdOrPath, SlackService slackNotifications) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("webhook", slackNotifications.getWebhook(), true).withParam("username", slackNotifications.getUsername()).withParam("channel", slackNotifications.getDefaultChannel()).withParam("notify_only_broken_pipelines", slackNotifications.getNotifyOnlyBrokenPipelines()).withParam("notify_only_default_branch", slackNotifications.getNotifyOnlyDefaultBranch()).withParam("push_events", slackNotifications.getPushEvents()).withParam("issues_events", slackNotifications.getIssuesEvents()).withParam("confidential_issues_events", slackNotifications.getConfidentialIssuesEvents()).withParam("merge_requests_events", slackNotifications.getMergeRequestsEvents()).withParam("tag_push_events", slackNotifications.getTagPushEvents()).withParam("note_events", slackNotifications.getNoteEvents()).withParam("confidential_note_events", slackNotifications.getConfidentialNoteEvents()).withParam("pipeline_events", slackNotifications.getPipelineEvents()).withParam("wiki_page_events", slackNotifications.getWikiPageEvents()).withParam("push_channel", slackNotifications.getPushChannel()).withParam("issue_channel", slackNotifications.getIssueChannel()).withParam("confidential_issue_channel", slackNotifications.getConfidentialIssueChannel()).withParam("merge_request_channel", slackNotifications.getMergeRequestChannel()).withParam("note_channel", slackNotifications.getNoteChannel()).withParam("confidential_note_channel", slackNotifications.getConfidentialNoteChannel()).withParam("tag_push_channel", slackNotifications.getTagPushChannel()).withParam("pipeline_channel", slackNotifications.getPipelineChannel()).withParam("wiki_page_channel", slackNotifications.getWikiPageChannel());
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "slack");
        return (SlackService)response.readEntity(SlackService.class);
    }

    public void deleteSlackService(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "slack");
    }

    public JiraService getJiraService(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "jira");
        return (JiraService)response.readEntity(JiraService.class);
    }

    public JiraService updateJiraService(Object projectIdOrPath, JiraService jira) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("merge_requests_events", jira.getMergeRequestsEvents()).withParam("commit_events", jira.getCommitEvents()).withParam("url", jira.getUrl(), true).withParam("api_url", jira.getApiUrl()).withParam("project_key", jira.getProjectKey()).withParam("username", jira.getUsername(), true).withParam("password", jira.getPassword(), true).withParam("jira_issue_transition_id", jira.getJiraIssueTransitionId());
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "jira");
        return (JiraService)response.readEntity(JiraService.class);
    }

    public void deleteJiraService(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "jira");
    }

    public ExternalWikiService getExternalWikiService(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "external-wiki");
        return (ExternalWikiService)response.readEntity(ExternalWikiService.class);
    }

    public ExternalWikiService updateExternalWikiService(Object projectIdOrPath, ExternalWikiService externalWiki) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("external_wiki_url", externalWiki.getExternalWikiUrl());
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "external-wiki");
        return (ExternalWikiService)response.readEntity(ExternalWikiService.class);
    }

    public void deleteExternalWikiService(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "external-wiki");
    }
}

