/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Label;

public class LabelsApi
extends AbstractApi {
    public LabelsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Label> getLabels(Object projectIdOrPath) throws GitLabApiException {
        return this.getLabels(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Label> getLabels(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "labels");
        return (List)response.readEntity((GenericType)new GenericType<List<Label>>(){});
    }

    public Pager<Label> getLabels(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Label>(this, Label.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "labels");
    }

    public Stream<Label> getLabelsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getLabels(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Label createLabel(Object projectIdOrPath, String name, String color, String description) throws GitLabApiException {
        return this.createLabel(projectIdOrPath, name, color, description, null);
    }

    public Label createLabel(Object projectIdOrPath, String name, String color) throws GitLabApiException {
        return this.createLabel(projectIdOrPath, name, color, null, null);
    }

    public Label createLabel(Object projectIdOrPath, String name, String color, Integer priority) throws GitLabApiException {
        return this.createLabel(projectIdOrPath, name, color, null, priority);
    }

    public Label createLabel(Object projectIdOrPath, String name, String color, String description, Integer priority) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("color", color, true).withParam("description", description).withParam("priority", priority);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "labels"});
        return (Label)response.readEntity(Label.class);
    }

    public Label updateLabelName(Object projectIdOrPath, String name, String newName, String description, Integer priority) throws GitLabApiException {
        return this.updateLabel(projectIdOrPath, name, newName, null, description, priority);
    }

    public Label updateLabelColor(Object projectIdOrPath, String name, String color, String description, Integer priority) throws GitLabApiException {
        return this.updateLabel(projectIdOrPath, name, null, color, description, priority);
    }

    public Label updateLabel(Object projectIdOrPath, String name, String newName, String color, String description, Integer priority) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("new_name", newName).withParam("color", color).withParam("description", description).withParam("priority", priority);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "labels");
        return (Label)response.readEntity(Label.class);
    }

    public void deleteLabel(Object projectIdOrPath, String name) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true);
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "labels");
    }

    public Label subscribeLabel(Object projectIdOrPath, Integer labelId) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "labels", labelId, "subscribe"});
        return (Label)response.readEntity(Label.class);
    }

    public Label unsubscribeLabel(Object projectIdOrPath, Integer labelId) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "labels", labelId, "unsubscribe"});
        return (Label)response.readEntity(Label.class);
    }
}

