/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.RepositoryFile;

public class RepositoryFileApi
extends AbstractApi {
    public RepositoryFileApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public RepositoryFile getFile(String filePath, Integer projectId, String ref) throws GitLabApiException {
        Form form = new Form();
        this.addFormParam(form, "file_path", filePath, true);
        this.addFormParam(form, "ref", ref, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", projectId, "repository", "files");
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    public RepositoryFile createFile(RepositoryFile file, Integer projectId, String branchName, String commitMessage) throws GitLabApiException {
        Form formData = this.file2form(file, branchName, commitMessage);
        Response response = this.post(Response.Status.CREATED, formData, "projects", projectId, "repository", "files");
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    public RepositoryFile updateFile(RepositoryFile file, Integer projectId, String branchName, String commitMessage) throws GitLabApiException {
        Form form = this.file2form(file, branchName, commitMessage);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", projectId, "repository", "files");
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    public void deleteFile(String filePath, Integer projectId, String branchName, String commitMessage) throws GitLabApiException {
        if (filePath == null) {
            throw new RuntimeException("filePath cannot be null");
        }
        Form form = new Form();
        this.addFormParam(form, "file_path", filePath, true);
        this.addFormParam(form, "branch_name", branchName, true);
        this.addFormParam(form, "commit_message", commitMessage, true);
        this.delete(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", projectId, "repository", "files");
    }

    private Form file2form(RepositoryFile file, String branchName, String commitMessage) {
        Form form = new Form();
        this.addFormParam(form, "file_path", file.getFilePath(), true);
        this.addFormParam(form, "branch_name", branchName, true);
        this.addFormParam(form, "encoding", file.getEncoding(), false);
        this.addFormParam(form, "content", file.getContent(), true);
        this.addFormParam(form, "commit_message", commitMessage, true);
        return form;
    }
}

