/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Utils;
import org.gitlab4j.api.models.Branch;
import org.gitlab4j.api.models.Tag;
import org.gitlab4j.api.models.TreeItem;

public class RepositoryApi
extends AbstractApi {
    public RepositoryApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Branch> getBranches(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "repository", "branches");
        return (List)response.readEntity((GenericType)new GenericType<List<Branch>>(){});
    }

    public Branch getBranch(Integer projectId, String branchName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "repository", "branches", branchName);
        return (Branch)response.readEntity(Branch.class);
    }

    public Branch createBranch(Integer projectId, String branchName, String ref) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("branch_name", branchName, true).withParam("ref", ref, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "branches");
        return (Branch)response.readEntity(Branch.class);
    }

    public Tag createTag(Integer projectId, String tagName, String ref, String message, String release_description) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("tag_name", tagName, true).withParam("ref", ref, true).withParam("message", message, false).withParam("release_description", release_description, false);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "tags");
        return (Tag)response.readEntity(Tag.class);
    }

    public void deleteBranch(Integer projectId, String branchName) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", projectId, "repository", "branches", branchName);
    }

    public Branch protectBranch(Integer projectId, String branchName) throws GitLabApiException {
        Response response = this.put(Response.Status.OK, null, "projects", projectId, "repository", "branches", branchName, "protect");
        return (Branch)response.readEntity(Branch.class);
    }

    public Branch unprotectBranch(Integer projectId, String branchName) throws GitLabApiException {
        Response response = this.put(Response.Status.OK, null, "projects", projectId, "repository", "branches", branchName, "unprotect");
        return (Branch)response.readEntity(Branch.class);
    }

    public List<Tag> getTags(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "repository", "tags");
        return (List)response.readEntity((GenericType)new GenericType<List<Tag>>(){});
    }

    public List<TreeItem> getTree(Integer projectId) throws GitLabApiException {
        return this.getTree(projectId, "/", "master");
    }

    public List<TreeItem> getTree(Integer projectId, String filePath, String refName) throws GitLabApiException {
        return this.getTree(projectId, filePath, refName, false);
    }

    public List<TreeItem> getTree(Integer projectId, String filePath, String refName, Boolean recursive) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("id", projectId, true).withParam("path", filePath, false).withParam("ref_name", refName, false).withParam("recursive", recursive, false);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "tree");
        return (List)response.readEntity((GenericType)new GenericType<List<TreeItem>>(){});
    }

    public String getRawFileContent(Integer projectId, String commitOrBranchName, String filepath) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("filepath", filepath, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "blobs", commitOrBranchName);
        return (String)response.readEntity(String.class);
    }

    public String getRawBlobCotent(Integer projectId, String sha) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "repository", "raw_blobs", sha);
        return (String)response.readEntity(String.class);
    }

    public InputStream getRepositoryArchive(Integer projectId, String sha) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "archive");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public File getRepositoryArchive(Integer projectId, String sha, File directory) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "archive");
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = Utils.getFilenameFromContentDisposition(response);
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }
}

