/*
 * Decompiled with CFR 0.152.
 */
package org.gillius.jfxutils.tab;

import java.lang.ref.WeakReference;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;

public class TabUtil {
    public static final DataFormat TAB_TYPE = new DataFormat(new String[]{"nonserializableObject/JfxTab"});
    private static WeakReference<Tab> dndTab;

    public static Tab newDraggableTab(String label) {
        Tab rr = new Tab();
        rr.setGraphic((Node)new Label(label));
        TabUtil.makeDraggable(rr);
        return rr;
    }

    public static void makeDraggable(final Tab tab) {
        tab.getGraphic().setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Dragboard dragboard = tab.getGraphic().startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.put((Object)TAB_TYPE, (Object)1);
                dndTab = new WeakReference<Tab>(tab);
                dragboard.setContent((Map)clipboardContent);
                event.consume();
            }
        });
    }

    public static void makeDroppable(final TabPane tabPane) {
        tabPane.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Tab tab;
                if (event.getDragboard().hasContent(TAB_TYPE) && (tab = (Tab)dndTab.get()) != null && tab.getTabPane() != tabPane) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                    event.consume();
                }
            }
        });
        tabPane.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                if (event.getDragboard().hasContent(TAB_TYPE)) {
                    Tab tab = (Tab)dndTab.get();
                    if (tab != null && tab.getTabPane() != tabPane) {
                        tab.getTabPane().getTabs().remove((Object)tab);
                        tabPane.getTabs().add((Object)tab);
                        event.setDropCompleted(true);
                        event.consume();
                    }
                    dndTab = null;
                }
            }
        });
    }
}

