/*
 * Decompiled with CFR 0.152.
 */
package org.gillius.jfxutils.chart;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.gillius.jfxutils.EventHandlerManager;
import org.gillius.jfxutils.chart.AxisConstraint;
import org.gillius.jfxutils.chart.AxisConstraintStrategies;
import org.gillius.jfxutils.chart.AxisConstraintStrategy;
import org.gillius.jfxutils.chart.DefaultChartInputContext;
import org.gillius.jfxutils.chart.XYChartInfo;

public class ChartZoomManager {
    public static final EventHandler<MouseEvent> DEFAULT_FILTER = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != MouseButton.PRIMARY) {
                mouseEvent.consume();
            }
        }
    };
    private final SimpleDoubleProperty rectX = new SimpleDoubleProperty();
    private final SimpleDoubleProperty rectY = new SimpleDoubleProperty();
    private final SimpleBooleanProperty selecting = new SimpleBooleanProperty(false);
    private final DoubleProperty zoomDurationMillis = new SimpleDoubleProperty(750.0);
    private final BooleanProperty zoomAnimated = new SimpleBooleanProperty(true);
    private final BooleanProperty mouseWheelZoomAllowed = new SimpleBooleanProperty(true);
    private AxisConstraint zoomMode = AxisConstraint.None;
    private AxisConstraintStrategy axisConstraintStrategy = AxisConstraintStrategies.getIgnoreOutsideChart();
    private AxisConstraintStrategy mouseWheelAxisConstraintStrategy = AxisConstraintStrategies.getDefault();
    private EventHandler<? super MouseEvent> mouseFilter = DEFAULT_FILTER;
    private final EventHandlerManager handlerManager;
    private final Rectangle selectRect;
    private final ValueAxis<?> xAxis;
    private final ValueAxis<?> yAxis;
    private final XYChartInfo chartInfo;
    private final Timeline zoomAnimation = new Timeline();

    public ChartZoomManager(Pane chartPane, Rectangle selectRect, XYChart<?, ?> chart) {
        this.selectRect = selectRect;
        this.xAxis = (ValueAxis)chart.getXAxis();
        this.yAxis = (ValueAxis)chart.getYAxis();
        this.chartInfo = new XYChartInfo(chart, (Node)chartPane);
        this.handlerManager = new EventHandlerManager((Node)chartPane);
        this.handlerManager.addEventHandler(false, MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (ChartZoomManager.this.passesFilter(mouseEvent)) {
                    ChartZoomManager.this.onMousePressed(mouseEvent);
                }
            }
        });
        this.handlerManager.addEventHandler(false, MouseEvent.DRAG_DETECTED, new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (ChartZoomManager.this.passesFilter(mouseEvent)) {
                    ChartZoomManager.this.onDragStart();
                }
            }
        });
        this.handlerManager.addEventHandler(false, MouseEvent.MOUSE_DRAGGED, new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ChartZoomManager.this.onMouseDragged(mouseEvent);
            }
        });
        this.handlerManager.addEventHandler(false, MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ChartZoomManager.this.onMouseReleased();
            }
        });
        this.handlerManager.addEventHandler(false, ScrollEvent.ANY, new MouseWheelZoomHandler());
    }

    public AxisConstraintStrategy getAxisConstraintStrategy() {
        return this.axisConstraintStrategy;
    }

    public void setAxisConstraintStrategy(AxisConstraintStrategy axisConstraintStrategy) {
        this.axisConstraintStrategy = axisConstraintStrategy;
    }

    public AxisConstraintStrategy getMouseWheelAxisConstraintStrategy() {
        return this.mouseWheelAxisConstraintStrategy;
    }

    public void setMouseWheelAxisConstraintStrategy(AxisConstraintStrategy mouseWheelAxisConstraintStrategy) {
        this.mouseWheelAxisConstraintStrategy = mouseWheelAxisConstraintStrategy;
    }

    public boolean isZoomAnimated() {
        return this.zoomAnimated.get();
    }

    public BooleanProperty zoomAnimatedProperty() {
        return this.zoomAnimated;
    }

    public void setZoomAnimated(boolean zoomAnimated) {
        this.zoomAnimated.set(zoomAnimated);
    }

    public double getZoomDurationMillis() {
        return this.zoomDurationMillis.get();
    }

    public DoubleProperty zoomDurationMillisProperty() {
        return this.zoomDurationMillis;
    }

    public void setZoomDurationMillis(double zoomDurationMillis) {
        this.zoomDurationMillis.set(zoomDurationMillis);
    }

    public boolean isMouseWheelZoomAllowed() {
        return this.mouseWheelZoomAllowed.get();
    }

    public BooleanProperty mouseWheelZoomAllowedProperty() {
        return this.mouseWheelZoomAllowed;
    }

    public void setMouseWheelZoomAllowed(boolean allowed) {
        this.mouseWheelZoomAllowed.set(allowed);
    }

    public EventHandler<? super MouseEvent> getMouseFilter() {
        return this.mouseFilter;
    }

    public void setMouseFilter(EventHandler<? super MouseEvent> mouseFilter) {
        this.mouseFilter = mouseFilter;
    }

    public void start() {
        this.handlerManager.addAllHandlers();
        this.selectRect.widthProperty().bind((ObservableValue)this.rectX.subtract((ObservableNumberValue)this.selectRect.translateXProperty()));
        this.selectRect.heightProperty().bind((ObservableValue)this.rectY.subtract((ObservableNumberValue)this.selectRect.translateYProperty()));
        this.selectRect.visibleProperty().bind((ObservableValue)this.selecting);
    }

    public void stop() {
        this.handlerManager.removeAllHandlers();
        this.selecting.set(false);
        this.selectRect.widthProperty().unbind();
        this.selectRect.heightProperty().unbind();
        this.selectRect.visibleProperty().unbind();
    }

    private boolean passesFilter(MouseEvent event) {
        if (this.mouseFilter != null) {
            MouseEvent cloned = (MouseEvent)event.clone();
            this.mouseFilter.handle((Event)cloned);
            if (cloned.isConsumed()) {
                return false;
            }
        }
        return true;
    }

    private void onMousePressed(MouseEvent mouseEvent) {
        double x = mouseEvent.getX();
        double y = mouseEvent.getY();
        Rectangle2D plotArea = this.chartInfo.getPlotArea();
        DefaultChartInputContext context = new DefaultChartInputContext(this.chartInfo, x, y);
        this.zoomMode = this.axisConstraintStrategy.getConstraint(context);
        if (this.zoomMode == AxisConstraint.Both) {
            this.selectRect.setTranslateX(x);
            this.selectRect.setTranslateY(y);
            this.rectX.set(x);
            this.rectY.set(y);
        } else if (this.zoomMode == AxisConstraint.Horizontal) {
            this.selectRect.setTranslateX(x);
            this.selectRect.setTranslateY(plotArea.getMinY());
            this.rectX.set(x);
            this.rectY.set(plotArea.getMaxY());
        } else if (this.zoomMode == AxisConstraint.Vertical) {
            this.selectRect.setTranslateX(plotArea.getMinX());
            this.selectRect.setTranslateY(y);
            this.rectX.set(plotArea.getMaxX());
            this.rectY.set(y);
        }
    }

    private void onDragStart() {
        if (this.zoomMode != AxisConstraint.None) {
            this.selecting.set(true);
        }
    }

    private void onMouseDragged(MouseEvent mouseEvent) {
        if (!this.selecting.get()) {
            return;
        }
        Rectangle2D plotArea = this.chartInfo.getPlotArea();
        if (this.zoomMode == AxisConstraint.Both || this.zoomMode == AxisConstraint.Horizontal) {
            double x = mouseEvent.getX();
            x = Math.max(x, this.selectRect.getTranslateX());
            x = Math.min(x, plotArea.getMaxX());
            this.rectX.set(x);
        }
        if (this.zoomMode == AxisConstraint.Both || this.zoomMode == AxisConstraint.Vertical) {
            double y = mouseEvent.getY();
            y = Math.max(y, this.selectRect.getTranslateY());
            y = Math.min(y, plotArea.getMaxY());
            this.rectY.set(y);
        }
    }

    private void onMouseReleased() {
        if (!this.selecting.get()) {
            return;
        }
        if (this.selectRect.getWidth() == 0.0 || this.selectRect.getHeight() == 0.0) {
            this.selecting.set(false);
            return;
        }
        Rectangle2D zoomWindow = this.chartInfo.getDataCoordinates(this.selectRect.getTranslateX(), this.selectRect.getTranslateY(), this.rectX.get(), this.rectY.get());
        this.xAxis.setAutoRanging(false);
        this.yAxis.setAutoRanging(false);
        if (this.zoomAnimated.get()) {
            this.zoomAnimation.stop();
            this.zoomAnimation.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.xAxis.lowerBoundProperty(), (Object)this.xAxis.getLowerBound()), new KeyValue((WritableValue)this.xAxis.upperBoundProperty(), (Object)this.xAxis.getUpperBound()), new KeyValue((WritableValue)this.yAxis.lowerBoundProperty(), (Object)this.yAxis.getLowerBound()), new KeyValue((WritableValue)this.yAxis.upperBoundProperty(), (Object)this.yAxis.getUpperBound())}), new KeyFrame(Duration.millis((double)this.zoomDurationMillis.get()), new KeyValue[]{new KeyValue((WritableValue)this.xAxis.lowerBoundProperty(), (Object)zoomWindow.getMinX()), new KeyValue((WritableValue)this.xAxis.upperBoundProperty(), (Object)zoomWindow.getMaxX()), new KeyValue((WritableValue)this.yAxis.lowerBoundProperty(), (Object)zoomWindow.getMinY()), new KeyValue((WritableValue)this.yAxis.upperBoundProperty(), (Object)zoomWindow.getMaxY())})});
            this.zoomAnimation.play();
        } else {
            this.zoomAnimation.stop();
            this.xAxis.setLowerBound(zoomWindow.getMinX());
            this.xAxis.setUpperBound(zoomWindow.getMaxX());
            this.yAxis.setLowerBound(zoomWindow.getMinY());
            this.yAxis.setUpperBound(zoomWindow.getMaxY());
        }
        this.selecting.set(false);
    }

    private static double getBalance(double val, double min, double max) {
        if (val <= min) {
            return 0.0;
        }
        if (val >= max) {
            return 1.0;
        }
        return (val - min) / (max - min);
    }

    private class MouseWheelZoomHandler
    implements EventHandler<ScrollEvent> {
        private boolean ignoring = false;

        private MouseWheelZoomHandler() {
        }

        public void handle(ScrollEvent event) {
            EventType eventType = event.getEventType();
            if (eventType == ScrollEvent.SCROLL_STARTED) {
                this.ignoring = true;
            } else if (eventType == ScrollEvent.SCROLL_FINISHED) {
                this.ignoring = false;
            } else if (eventType == ScrollEvent.SCROLL && ChartZoomManager.this.mouseWheelZoomAllowed.get() && !this.ignoring && !event.isInertia() && event.getDeltaY() != 0.0 && event.getTouchCount() == 0) {
                double eventX = event.getX();
                double eventY = event.getY();
                DefaultChartInputContext context = new DefaultChartInputContext(ChartZoomManager.this.chartInfo, eventX, eventY);
                AxisConstraint zoomMode = ChartZoomManager.this.mouseWheelAxisConstraintStrategy.getConstraint(context);
                if (zoomMode == AxisConstraint.None) {
                    return;
                }
                ChartZoomManager.this.zoomAnimation.stop();
                Point2D dataCoords = ChartZoomManager.this.chartInfo.getDataCoordinates(eventX, eventY);
                double xZoomBalance = ChartZoomManager.getBalance(dataCoords.getX(), ChartZoomManager.this.xAxis.getLowerBound(), ChartZoomManager.this.xAxis.getUpperBound());
                double yZoomBalance = ChartZoomManager.getBalance(dataCoords.getY(), ChartZoomManager.this.yAxis.getLowerBound(), ChartZoomManager.this.yAxis.getUpperBound());
                double direction = -Math.signum(event.getDeltaY());
                double zoomAmount = 0.2 * direction;
                if (zoomMode == AxisConstraint.Both || zoomMode == AxisConstraint.Horizontal) {
                    double xZoomDelta = (ChartZoomManager.this.xAxis.getUpperBound() - ChartZoomManager.this.xAxis.getLowerBound()) * zoomAmount;
                    ChartZoomManager.this.xAxis.setAutoRanging(false);
                    ChartZoomManager.this.xAxis.setLowerBound(ChartZoomManager.this.xAxis.getLowerBound() - xZoomDelta * xZoomBalance);
                    ChartZoomManager.this.xAxis.setUpperBound(ChartZoomManager.this.xAxis.getUpperBound() + xZoomDelta * (1.0 - xZoomBalance));
                }
                if (zoomMode == AxisConstraint.Both || zoomMode == AxisConstraint.Vertical) {
                    double yZoomDelta = (ChartZoomManager.this.yAxis.getUpperBound() - ChartZoomManager.this.yAxis.getLowerBound()) * zoomAmount;
                    ChartZoomManager.this.yAxis.setAutoRanging(false);
                    ChartZoomManager.this.yAxis.setLowerBound(ChartZoomManager.this.yAxis.getLowerBound() - yZoomDelta * yZoomBalance);
                    ChartZoomManager.this.yAxis.setUpperBound(ChartZoomManager.this.yAxis.getUpperBound() + yZoomDelta * (1.0 - yZoomBalance));
                }
            }
        }
    }
}

