/*
 * Decompiled with CFR 0.152.
 */
package org.gillius.jfxutils;

import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class JFXUtil {
    public static double getXShift(Node descendant, Node ancestor) {
        double ret = 0.0;
        Node curr = descendant;
        while (curr != ancestor) {
            ret += curr.getLocalToParentTransform().getTx();
            if ((curr = curr.getParent()) != null) continue;
            throw new IllegalArgumentException("'descendant' Node is not a descendant of 'ancestor");
        }
        return ret;
    }

    public static double getYShift(Node descendant, Node ancestor) {
        double ret = 0.0;
        Node curr = descendant;
        while (curr != ancestor) {
            ret += curr.getLocalToParentTransform().getTy();
            if ((curr = curr.getParent()) != null) continue;
            throw new IllegalArgumentException("'descendant' Node is not a descendant of 'ancestor");
        }
        return ret;
    }

    public static void replaceComponent(Node original, Node replacement) {
        Pane parent = (Pane)original.getParent();
        replacement.getProperties().putAll((Map)original.getProperties());
        original.getProperties().clear();
        ObservableList children = parent.getChildren();
        int originalIndex = children.indexOf((Object)original);
        if (parent instanceof BorderPane) {
            BorderPane borderPane = (BorderPane)parent;
            if (borderPane.getTop() == original) {
                children.remove((Object)original);
                borderPane.setTop(replacement);
            } else if (borderPane.getLeft() == original) {
                children.remove((Object)original);
                borderPane.setLeft(replacement);
            } else if (borderPane.getCenter() == original) {
                children.remove((Object)original);
                borderPane.setCenter(replacement);
            } else if (borderPane.getRight() == original) {
                children.remove((Object)original);
                borderPane.setRight(replacement);
            } else if (borderPane.getBottom() == original) {
                children.remove((Object)original);
                borderPane.setBottom(replacement);
            }
        } else {
            children.set(originalIndex, (Object)replacement);
        }
    }

    public static StackPane createScalePane(Region region, double w, double h, boolean override) {
        if (override || region.getPrefWidth() == -1.0) {
            region.setPrefWidth(w);
        } else {
            w = region.getPrefWidth();
        }
        if (override || region.getPrefHeight() == -1.0) {
            region.setPrefHeight(h);
        } else {
            h = region.getPrefHeight();
        }
        StackPane ret = new StackPane();
        ret.setPrefWidth(w);
        ret.setPrefHeight(h);
        if (region.getParent() != null) {
            JFXUtil.replaceComponent((Node)region, (Node)ret);
        }
        Group group = new Group(new Node[]{region});
        ret.getChildren().add((Object)group);
        group.scaleXProperty().bind((ObservableValue)ret.widthProperty().divide(w));
        group.scaleYProperty().bind((ObservableValue)ret.heightProperty().divide(h));
        return ret;
    }
}

