/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.gephi.maven.ManifestUtils;
import org.gephi.maven.MetadataUtils;
import org.gephi.maven.ModuleUtils;
import org.gephi.maven.json.PluginMetadata;

@Mojo(name="validate", aggregator=true, defaultPhase=LifecyclePhase.VALIDATE)
public class Validate
extends AbstractMojo {
    @Parameter(required=true, defaultValue="src/main/nbm/manifest.mf")
    private String sourceManifestFile;
    @Parameter(required=true, readonly=true, property="reactorProjects")
    private List<MavenProject> reactorProjects;
    private ManifestUtils manifestUtils;
    @Parameter(required=true, readonly=true, property="project")
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.manifestUtils = new ManifestUtils(this.sourceManifestFile, this.getLog());
        if (this.reactorProjects != null && this.reactorProjects.size() > 0) {
            this.getLog().debug((CharSequence)("Found " + this.reactorProjects.size() + " projects in reactor"));
            ArrayList<MavenProject> modules = new ArrayList<MavenProject>();
            for (MavenProject proj : this.reactorProjects) {
                if (!proj.getPackaging().equals("nbm")) continue;
                this.getLog().debug((CharSequence)("Found 'nbm' project '" + proj.getName() + "' with artifactId=" + proj.getArtifactId() + " and groupId=" + proj.getGroupId()));
                modules.add(proj);
            }
            if (modules.isEmpty()) {
                throw new MojoExecutionException("No 'nbm' modules have been detected, make sure to add folders to <modules> into pom");
            }
            if (modules.size() == 1) {
                this.executeSingleModuleProject((MavenProject)modules.get(0));
            } else {
                this.executeMultiModuleProject(modules);
            }
        } else {
            throw new MojoExecutionException("The project should be a reactor project");
        }
    }

    private void executeSingleModuleProject(MavenProject moduleProject) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Unique module found: '" + moduleProject.getName() + "'"));
        this.checkGephiVersion(moduleProject);
        this.checkMetadata(moduleProject);
    }

    private void executeMultiModuleProject(List<MavenProject> projects) throws MojoExecutionException, MojoFailureException {
        Map<MavenProject, List<MavenProject>> tree = ModuleUtils.getModulesTree(projects, this.getLog());
        if (tree.isEmpty()) {
            throw new MojoExecutionException("Multiple modules have been found but no suite detected, make sure one of the module has dependencies on the others");
        }
        if (tree.size() > 1) {
            throw new MojoExecutionException("Multiple module suites have been found, this is not supported");
        }
        Map.Entry<MavenProject, List<MavenProject>> entry = tree.entrySet().iterator().next();
        List<MavenProject> children = entry.getValue();
        this.checkSameGephiVersion(children);
        children.remove(entry.getKey());
        this.getLog().info((CharSequence)("Suite of modules found: '" + entry.getKey().getName() + "'"));
        for (MavenProject child : children) {
            this.getLog().info((CharSequence)("   '" + child.getName() + "' is a dependency"));
        }
        for (MavenProject child : children) {
            this.checkGephiVersion(child);
            this.manifestUtils.checkManifestShowClientFalse(child);
        }
        this.checkGephiVersion(entry.getKey());
        this.checkMetadata(entry.getKey());
    }

    private void checkMetadata(MavenProject moduleProject) throws MojoExecutionException {
        if (MetadataUtils.getLicenseName(moduleProject) == null) {
            throw new MojoExecutionException("The 'licenseName' configuration should be set for the project '" + moduleProject.getName() + "'. This can be added to the configuration of the 'nbm-maven-plugin' plugin. In addition, a 'licenseFile' can be specified, relative to the module's root folder.");
        }
        if (MetadataUtils.getAuthors(moduleProject) == null) {
            throw new MojoExecutionException("The 'author' configuration should be set fot the project '" + moduleProject.getName() + "'. This can be added to the configuration of the 'nbm-maven-plugin' plugin. Multiple authors can be specificed, separated by a comma.");
        }
        this.manifestUtils.readManifestMetadata(moduleProject, new PluginMetadata());
    }

    private void checkGephiVersion(MavenProject moduleProject) throws MojoExecutionException {
        String projectVersion;
        String moduleVersion = moduleProject.getProperties().getProperty("gephi.version");
        if (!moduleVersion.equals(projectVersion = this.project.getProperties().getProperty("gephi.version"))) {
            this.getLog().warn((CharSequence)("The project '" + moduleProject.getName() + "' depends on Gephi version '" + moduleVersion + "' but '" + projectVersion + "' is expected, it will be ignored"));
        }
    }

    private void checkSameGephiVersion(List<MavenProject> projects) throws MojoExecutionException {
        String key = null;
        for (MavenProject moduleProject : projects) {
            String moduleVersion = moduleProject.getProperties().getProperty("gephi.version");
            if (key == null) {
                key = moduleVersion;
                continue;
            }
            if (key.equals(moduleVersion)) continue;
            throw new MojoExecutionException("Inconsistent 'gephi.version' property between modules of a same suite. All modules of the same and their plugin dependencies (if any) should have the same 'gephi.version'.");
        }
    }
}

