/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.maven;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import net.coobird.thumbnailator.resizers.Resizer;
import net.coobird.thumbnailator.resizers.Resizers;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.gephi.maven.json.Image;

public class ScreenshotUtils {
    private static final String THUMBNAIL_SUFFIX = "-thumbnail";

    protected static List<Image> copyScreenshots(MavenProject mavenProject, File outputFolder, String urlPrefix, Log log) throws MojoExecutionException {
        File folder = new File(mavenProject.getBasedir(), "src/img");
        if (folder.exists()) {
            log.debug((CharSequence)("Folder '" + folder.getAbsolutePath() + "' exists"));
            File[] files = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.startsWith(".") && (name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif")) && !name.contains(ScreenshotUtils.THUMBNAIL_SUFFIX);
                }
            });
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
            log.debug((CharSequence)(files.length + " images found in source folder"));
            if (outputFolder.mkdirs()) {
                log.debug((CharSequence)("Output folder '" + outputFolder.getAbsolutePath() + "' was created"));
            }
            ArrayList<Image> images = new ArrayList<Image>();
            for (File file : files) {
                if (file.getName().contains(" ")) {
                    throw new MojoExecutionException("Image file '" + file.getAbsolutePath() + "' contains spaces. Please rename image and try again");
                }
                String fileName = file.getName().substring(0, file.getName().lastIndexOf(".")) + ".png";
                File imageDestFile = new File(outputFolder, fileName);
                try {
                    Thumbnails.of((File[])new File[]{file}).outputFormat("png").outputQuality(0.9).resizer((Resizer)Resizers.NULL).scale(1.0).toFile(imageDestFile);
                }
                catch (IOException ex) {
                    log.error((CharSequence)("Can't copy image file from '" + file.getAbsolutePath() + "' to '" + imageDestFile.getAbsolutePath() + "'"), (Throwable)ex);
                }
                Image image = new Image();
                image.image = urlPrefix + fileName;
                images.add(image);
                String thumFileName = file.getName().substring(0, file.getName().lastIndexOf(".")) + THUMBNAIL_SUFFIX + ".png";
                File thumbFile = new File(outputFolder, thumFileName);
                if (!thumbFile.exists()) {
                    try {
                        Thumbnails.of((File[])new File[]{file}).outputFormat("png").outputQuality(0.9).size(140, 140).crop((Position)Positions.CENTER).toFile(thumbFile);
                        log.debug((CharSequence)("Created thumbnail in file '" + thumbFile.getAbsolutePath() + "'"));
                        image.thumbnail = urlPrefix + thumFileName;
                    }
                    catch (IOException ex) {
                        log.error((CharSequence)("Can't create thumbnail for image file '" + file.getAbsolutePath() + "'"), (Throwable)ex);
                    }
                }
                log.info((CharSequence)("Attached image '" + file.getName() + "' to plugin " + mavenProject.getName()));
            }
            return images;
        }
        log.debug((CharSequence)("Folder '" + folder.getAbsolutePath() + "' was not found"));
        return null;
    }
}

