/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="run", aggregator=true, defaultPhase=LifecyclePhase.NONE)
public class Run
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}/userdir", property="gephi.userdir")
    protected File gephiUserdir;
    @Parameter(required=true, defaultValue="gephi")
    protected String brandingToken;
    @Parameter
    private List<String> clusters;
    @Parameter(property="run.params.debug")
    protected String debugAdditionalArguments;
    @Parameter(required=true, defaultValue="${project.build.directory}/gephi")
    private File gephiDirectory;

    public void execute() throws MojoExecutionException {
        File exec;
        this.gephiUserdir.mkdirs();
        File appbasedir = this.gephiDirectory;
        if (!appbasedir.exists()) {
            throw new MojoExecutionException("The directory that shall contain the gephi application, doesn't exist (" + appbasedir.getAbsolutePath() + ")\n Please invoke 'mvn package' on the project first");
        }
        boolean windows = Os.isFamily((String)"windows");
        Commandline cmdLine = new Commandline();
        if (windows) {
            File exec64;
            exec = new File(appbasedir, "bin\\" + this.brandingToken + ".exe");
            String jdkHome = System.getenv("JAVA_HOME");
            if (jdkHome != null && new File(jdkHome, "jre\\lib\\amd64\\jvm.cfg").exists() && (exec64 = new File(appbasedir, "bin\\" + this.brandingToken + "64.exe")).isFile()) {
                exec = exec64;
            }
            cmdLine.addArguments(new String[]{"--console", "suppress"});
        } else {
            exec = new File(appbasedir, "bin/" + this.brandingToken);
        }
        cmdLine.setExecutable(exec.getAbsolutePath());
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--userdir");
            args.add(this.gephiUserdir.getAbsolutePath());
            args.add("-J-Dnetbeans.logger.console=true");
            args.add("-J-ea");
            args.add("--branding");
            args.add(this.brandingToken);
            if (this.clusters != null && !this.clusters.isEmpty()) {
                StringBuilder sBuilder = new StringBuilder();
                for (String cluster : this.clusters) {
                    sBuilder.append(cluster);
                    sBuilder.append(File.pathSeparator);
                }
                sBuilder.deleteCharAt(sBuilder.length() - 1);
                File confFile = windows ? new File(appbasedir, "etc\\" + this.brandingToken + ".conf") : new File(appbasedir, "etc/" + this.brandingToken + ".conf");
                this.updateLine(confFile, "#extra_clusters=", "extra_clusters=" + sBuilder.toString());
            }
            if (System.getenv("JAVA_HOME") != null) {
                args.add("--jdkhome");
                args.add(System.getenv("JAVA_HOME"));
            }
            cmdLine.addArguments(args.toArray(new String[0]));
            cmdLine.addArguments(CommandLineUtils.translateCommandline((String)this.getDebugAdditionalArguments()));
            this.getLog().info((CharSequence)("Executing: " + cmdLine.toString()));
            StreamConsumer out = new StreamConsumer(){

                public void consumeLine(String line) {
                    Run.this.getLog().info((CharSequence)line);
                }
            };
            CommandLineUtils.executeCommandLine((Commandline)cmdLine, (StreamConsumer)out, (StreamConsumer)out);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed executing Gephi", (Exception)e);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed executing Gephi", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed executing Gephi", e);
        }
    }

    private void updateLine(File file, String search, String replace) throws IOException {
        String line;
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        File newFile = new File(file.getParent(), file.getName() + ".new");
        PrintWriter writer = new PrintWriter(newFile, "UTF-8");
        while ((line = fileReader.readLine()) != null) {
            line = line.replace(search, replace);
            writer.println(line);
        }
        fileReader.close();
        if (writer.checkError()) {
            throw new IOException("Could not rewrite configuration file");
        }
        writer.close();
        file.delete();
        newFile.renameTo(file);
    }

    private String getDebugAdditionalArguments() {
        return this.debugAdditionalArguments;
    }
}

