/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

public class ModuleUtils {
    protected static Map<MavenProject, List<MavenProject>> getModulesTree(List<MavenProject> modules, Log log) {
        LinkedHashMap<MavenProject, List<MavenProject>> result = new LinkedHashMap<MavenProject, List<MavenProject>>();
        for (MavenProject proj : modules) {
            List dependencies = proj.getDependencies();
            log.debug((CharSequence)("Investigating the " + dependencies.size() + " dependencies of project '" + proj.getName() + "'"));
            ArrayList<MavenProject> deps = new ArrayList<MavenProject>();
            deps.add(proj);
            result.put(proj, deps);
            for (Dependency d : dependencies) {
                for (MavenProject projDependency : modules) {
                    if (projDependency == proj || !projDependency.getArtifactId().equals(d.getArtifactId()) || !projDependency.getGroupId().equals(d.getGroupId()) || !projDependency.getVersion().equals(d.getVersion())) continue;
                    log.debug((CharSequence)("Found a dependency that matches another module '" + proj.getName() + "' -> '" + projDependency.getName() + "'"));
                    deps.add(projDependency);
                }
            }
        }
        ArrayList<MavenProject> toBeRemoved = new ArrayList<MavenProject>();
        block3: for (MavenProject proj : modules) {
            List projDeps = (List)result.get(proj);
            for (MavenProject proj2 : modules) {
                if (proj == proj2 || !((List)result.get(proj2)).containsAll(projDeps)) continue;
                log.debug((CharSequence)("Remove '" + proj.getName() + "' from list of top modules because is a dependency of '" + proj2.getName() + "'"));
                toBeRemoved.add(proj);
                continue block3;
            }
        }
        for (MavenProject mp : toBeRemoved) {
            result.remove(mp);
        }
        return result;
    }

    protected static String getModuleDownloadPath(MavenProject topPlugin, List<MavenProject> modules, File directory, Log log) throws MojoExecutionException {
        File dest;
        if (modules.size() > 1) {
            dest = new File(directory, topPlugin.getArtifactId() + "-" + topPlugin.getVersion() + ".zip");
            log.debug((CharSequence)("The plugin '" + topPlugin + "' is a suite, creating zip archive at '" + dest.getAbsolutePath() + "'"));
            try {
                ZipArchiver archiver = new ZipArchiver();
                for (MavenProject module : modules) {
                    File f = new File(directory, module.getArtifactId() + "-" + module.getVersion() + ".nbm");
                    if (!f.exists()) {
                        throw new MojoExecutionException("The NBM file '" + f.getAbsolutePath() + "' can't be found");
                    }
                    archiver.addFile(f, f.getName());
                    log.debug((CharSequence)("  Add file '" + f.getAbsolutePath() + "' to the archive"));
                }
                archiver.setCompress(false);
                archiver.setDestFile(dest);
                archiver.setForced(true);
                archiver.createArchive();
                log.info((CharSequence)("Created ZIP archive for project '" + topPlugin.getName() + "' at '" + dest.getAbsolutePath() + "'"));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Something went wrong with the creation of the ZIP archive for project '" + topPlugin.getName() + "'", (Exception)ex);
            }
            catch (ArchiverException ex) {
                throw new MojoExecutionException("Something went wrong with the creation of the ZIP archive for project '" + topPlugin.getName() + "'", (Exception)((Object)ex));
            }
        } else {
            dest = new File(directory, topPlugin.getArtifactId() + "-" + topPlugin.getVersion() + ".nbm");
            log.debug((CharSequence)("The plugin is not a suite, return nbm file '" + dest.getAbsolutePath() + "'"));
        }
        return dest.getName();
    }
}

