/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.gephi.maven.GenerateUtils;
import org.gephi.maven.MetadataUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Mojo(name="migrate", aggregator=true)
public class Migrate
extends AbstractMojo {
    @Parameter(required=true, readonly=true, property="project")
    private MavenProject project;
    private Set<Dependency> gephiDependencies;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File baseDir = this.project.getBasedir();
        this.getLog().info((CharSequence)"Start migrating ant-based plugin folder.");
        File pomFile = new File(baseDir, "pom.xml");
        if (!pomFile.exists()) {
            throw new MojoExecutionException("The 'pom.xml' file doesn' exist at '" + pomFile.getAbsolutePath() + "'");
        }
        String gephiVersion = this.project.getProperties().getProperty("gephi.version");
        if (gephiVersion == null) {
            throw new MojoExecutionException("Can't obtain gephi version number");
        }
        this.getLog().info((CharSequence)("Gephi version is defined as '" + gephiVersion + "'"));
        List<String> folders = this.collectFolders();
        if (folders.isEmpty()) {
            throw new MojoExecutionException("No plugin modules have been found this folder");
        }
        this.getLog().info((CharSequence)("Found " + folders.size() + " modules to migrate:"));
        for (String moduleStr : folders) {
            this.getLog().info((CharSequence)("  '" + moduleStr + "' will be migrated to 'modules/" + moduleStr + "'"));
        }
        HashMap<String, ProjectMetadata> foldersMetadata = new HashMap<String, ProjectMetadata>();
        for (String string : folders) {
            ProjectMetadata projectMetadata = new ProjectMetadata();
            File folder = new File(baseDir, string);
            File nbProjectFolder = this.checkNbproject(folder);
            File projectXMLFile = new File(nbProjectFolder, "project.xml");
            if (!projectXMLFile.exists()) {
                throw new MojoExecutionException("The 'project.xml' file can't be found at " + projectXMLFile.getAbsolutePath());
            }
            projectMetadata.codeNameBase = this.collectCodeName(projectXMLFile);
            this.getLog().debug((CharSequence)("Module: '" + string + "' has code name '" + projectMetadata.codeNameBase + "'"));
            projectMetadata.dependencies = this.collectDependencies(projectXMLFile, string);
            projectMetadata.publicPackages = this.collectPublicPackages(projectXMLFile);
            this.collectManifest(folder, projectMetadata);
            this.collectProjectProperties(nbProjectFolder, projectMetadata);
            foldersMetadata.put(string, projectMetadata);
        }
        for (Map.Entry entry : foldersMetadata.entrySet()) {
            File file;
            String folder = (String)entry.getKey();
            ProjectMetadata metadata = (ProjectMetadata)entry.getValue();
            File pluginFolder = new File(baseDir, "modules" + File.separator + folder);
            if (pluginFolder.exists()) {
                try {
                    this.getLog().warn((CharSequence)("The plugin folder 'modules" + File.separator + folder + "' already exists, the configuration will be overriden"));
                    FileUtils.deleteDirectory((File)pluginFolder);
                    this.getLog().debug((CharSequence)("Deleted folder '" + pluginFolder.getAbsolutePath() + "'"));
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error while deleting previous '" + folder + "' directory", (Exception)ex);
                }
            }
            GenerateUtils.createFolder(new File(baseDir, "modules" + File.separator + folder), this.getLog());
            String sourceCodeUrl = MetadataUtils.getSourceCodeUrlFromGit(this.project, this.getLog());
            this.getLog().debug((CharSequence)("Obtained source code url from Git: " + sourceCodeUrl));
            String org = metadata.codeNameBase;
            String artifact = metadata.codeNameBase;
            if (org.contains(".")) {
                artifact = org.substring(org.lastIndexOf(".") + 1);
                org = org.substring(0, org.lastIndexOf("."));
            }
            String licenseFile = null;
            String license = null;
            if (metadata.licenseFile != null && (file = new File(baseDir, folder + File.separator + metadata.licenseFile.replace('/', File.separatorChar))).exists()) {
                try {
                    File dest = new File(pluginFolder, file.getName());
                    FileUtils.copyFile((File)file, (File)dest);
                    licenseFile = dest.getName();
                    license = licenseFile.contains(".") ? licenseFile.substring(0, licenseFile.lastIndexOf(46)) : licenseFile;
                }
                catch (IOException ex) {
                    this.getLog().error((CharSequence)("Error while copying license file for module'" + folder + "'"), (Throwable)ex);
                }
            }
            if (metadata.author == null) {
                metadata.author = "Unknown";
            }
            File modulePomFile = new File(pluginFolder, "pom.xml");
            GenerateUtils.createTopPomFile(modulePomFile, gephiVersion, org, artifact, "1.0.0", folder, metadata.author, null, null, license, licenseFile, sourceCodeUrl, metadata.homepageUrl);
            this.getLog().debug((CharSequence)("Created 'pom.xml' file at '" + pluginFolder.getAbsolutePath() + "'"));
            this.insertDependencies(modulePomFile, metadata.dependencies);
            this.getLog().debug((CharSequence)("Inserted " + metadata.dependencies.size() + " dependencies into 'pom.xml'"));
            if (!metadata.publicPackages.isEmpty()) {
                this.insertPublicPackages(modulePomFile, metadata.publicPackages);
                this.getLog().debug((CharSequence)("Inserted " + metadata.publicPackages.size() + " public packages into 'pom.xml'"));
            }
            File srcMain = GenerateUtils.createFolder(new File(pluginFolder, "src" + File.separator + "main"), this.getLog());
            File nbmFolder = GenerateUtils.createFolder(new File(srcMain, "nbm"), this.getLog());
            File javaFolder = new File(srcMain, "java");
            File resourcesFolder = new File(srcMain, "resources");
            GenerateUtils.createFolder(javaFolder, this.getLog());
            GenerateUtils.createFolder(resourcesFolder, this.getLog());
            File srcFolder = new File(folder, "src");
            if (srcFolder.exists()) {
                try {
                    String[] pattern = new String[]{"**\\*.java", "**\\*.form"};
                    this.copyFiles(srcFolder, javaFolder, pattern, null);
                    this.getLog().debug((CharSequence)("Copied source folders to '" + javaFolder.getAbsolutePath() + "'"));
                    this.copyFiles(srcFolder, resourcesFolder, null, pattern);
                    this.getLog().debug((CharSequence)("Copied resources folders to '" + resourcesFolder.getAbsolutePath() + "'"));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error while copying source files", (Exception)e);
                }
            } else {
                this.getLog().warn((CharSequence)("The 'src' folder at '" + srcFolder.getAbsolutePath() + "' doesn't exists"));
            }
            File testFolder = new File(folder, "test");
            if (testFolder.exists()) {
                if (new File(testFolder, "unit" + File.separator + "src").exists()) {
                    testFolder = new File(testFolder, "unit" + File.separator + "src");
                }
                File srcTest = GenerateUtils.createFolder(new File(pluginFolder, "src" + File.separator + "test"), this.getLog());
                File testJavaFolder = new File(srcTest, "java");
                File testResourcesFolder = new File(srcTest, "resources");
                try {
                    String[] pattern = new String[]{"**\\*.java", "**\\*.form"};
                    this.copyFiles(testFolder, testJavaFolder, pattern, null);
                    this.getLog().debug((CharSequence)("Copied test source folders to '" + testJavaFolder.getAbsolutePath() + "'"));
                    this.copyFiles(testFolder, testResourcesFolder, null, pattern);
                    this.getLog().debug((CharSequence)("Copied test resources folders to '" + testResourcesFolder.getAbsolutePath() + "'"));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error while copying test source files", (Exception)e);
                }
            }
            if (metadata.category == null) {
                metadata.category = "Other Category";
            }
            if (metadata.localizingBundle != null) {
                GenerateUtils.createManifest(new File(nbmFolder, "manifest.mf"), metadata.localizingBundle);
            } else {
                GenerateUtils.createManifest(new File(nbmFolder, "manifest.mf"), metadata.brandingName, metadata.shortDescription, metadata.longDescription, metadata.category);
            }
            this.getLog().debug((CharSequence)("Created 'manifest.mf' file at '" + nbmFolder.getAbsolutePath() + "'"));
            GenerateUtils.createFolder(new File(pluginFolder, "src" + File.separator + "img"), this.getLog());
            GenerateUtils.addModuleToPom(pomFile, folder, this.getLog());
            this.getLog().debug((CharSequence)("Inserted '" + folder + "' into the list of modules in 'pom.xml'"));
        }
    }

    private void collectProjectProperties(File nbProjectFolder, ProjectMetadata projectMetadata) throws MojoExecutionException {
        File projectPropertiesFile = new File(nbProjectFolder, "project.properties");
        if (!projectPropertiesFile.exists()) {
            throw new MojoExecutionException("The 'project.properties' can't be found in '" + nbProjectFolder.getAbsolutePath() + "'");
        }
        Properties prop = new Properties();
        FileReader bundleReader = null;
        try {
            bundleReader = new FileReader(projectPropertiesFile);
            prop.load(bundleReader);
            projectMetadata.homepageUrl = prop.getProperty("nbm.homepage", null);
            projectMetadata.author = prop.getProperty("nbm.module.author", null);
            projectMetadata.licenseFile = prop.getProperty("license.file", null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading '" + projectPropertiesFile.getAbsolutePath() + "'", (Exception)e);
        }
        finally {
            if (bundleReader != null) {
                try {
                    bundleReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectManifest(File folder, ProjectMetadata projectMetadata) throws MojoExecutionException {
        File manifestFile = new File(folder, "manifest.mf");
        if (!manifestFile.exists()) {
            throw new MojoExecutionException("The 'manifest.mf' can't be found in '" + folder.getAbsolutePath() + "'");
        }
        Manifest manifest = null;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(new FileInputStream(manifestFile));
            manifest = new Manifest((Reader)reader);
        }
        catch (IOException exc) {
            try {
                throw new MojoExecutionException("Error reading manifest at " + manifestFile, (Exception)exc);
                catch (ManifestException ex) {
                    throw new MojoExecutionException("Error reading manifest at " + manifestFile, (Exception)((Object)ex));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        Manifest.Section section = null;
        if (manifest == null) {
            throw new MojoExecutionException("The manifest is malformed at '" + manifestFile.getAbsolutePath() + "'");
        }
        section = manifest.getMainSection();
        if (section.getAttributeValue("OpenIDE-Module-Localizing-Bundle") != null) {
            projectMetadata.localizingBundle = section.getAttributeValue("OpenIDE-Module-Localizing-Bundle");
            return;
        }
        projectMetadata.brandingName = section.getAttributeValue("OpenIDE-Module-Name");
        projectMetadata.shortDescription = section.getAttributeValue("OpenIDE-Module-Short-Description");
        projectMetadata.longDescription = section.getAttributeValue("OpenIDE-Module-Long-Description");
        projectMetadata.category = section.getAttributeValue("OpenIDE-Module-Display-Category");
    }

    private File checkNbproject(File folder) throws MojoExecutionException {
        File result = new File(folder, "nbproject");
        if (!result.exists()) {
            throw new MojoExecutionException("The 'nbproject' can't be found in '" + folder.getAbsolutePath() + "'");
        }
        return result;
    }

    private List<String> collectFolders() throws MojoExecutionException {
        ArrayList<String> result = new ArrayList<String>();
        for (File child : this.project.getBasedir().listFiles()) {
            if (!child.isDirectory() || !new File(child, "nbproject").exists()) continue;
            result.add(child.getName());
            this.getLog().debug((CharSequence)("Found module folder '" + child.getAbsolutePath() + "'"));
        }
        return result;
    }

    private List<String> collectPublicPackages(File projectXMLFile) throws MojoExecutionException {
        return this.getStringsFromXML(projectXMLFile, "/project/configuration/data/public-packages/package/text()");
    }

    private Set<Dependency> collectDependencies(File projectXMLFile, String moduleName) throws MojoExecutionException {
        if (this.gephiDependencies == null) {
            this.gephiDependencies = this.collectGephiDependencies();
            this.getLog().debug((CharSequence)(this.gephiDependencies.size() + " dependencies collected from 'modules/pom.xml'"));
        }
        HashSet<Dependency> result = new HashSet<Dependency>();
        List<String> deps = this.getStringsFromXML(projectXMLFile, "/project/configuration/data/module-dependencies/dependency/code-name-base/text()");
        this.getLog().debug((CharSequence)(deps.size() + " dependencies found in '" + projectXMLFile.getAbsolutePath() + "'"));
        for (String dep : deps) {
            Dependency dependency = null;
            if (dep.startsWith("org.gephi")) {
                String artifactId = dep.substring("org.gephi.".length()).replace('.', '-');
                dependency = new Dependency("org.gephi", artifactId);
            } else if (dep.startsWith("org.openide")) {
                dependency = new Dependency("org.netbeans.api", dep.replace('.', '-'));
            } else if (dep.startsWith("org.netbeans")) {
                dependency = new Dependency("org.netbeans.api", dep.replace('.', '-'));
            }
            if (dependency != null && this.gephiDependencies.contains(dependency)) {
                this.getLog().debug((CharSequence)("Found dependency '" + dependency + "' in '" + moduleName + "'"));
                result.add(dependency);
                continue;
            }
            this.getLog().warn((CharSequence)("The '" + dep + "' dependency in '" + moduleName + "' couldn't be migrated, please add it manually in 'modules/" + moduleName + "'"));
        }
        return result;
    }

    private String collectCodeName(File projectXMLFile) throws MojoExecutionException {
        return this.getStringFromXML(projectXMLFile, "/project/configuration/data/code-name-base/text()");
    }

    private String getStringFromXML(File file, String path) throws MojoExecutionException {
        NodeList nl = this.getNodeListFromXml(file, path);
        if (nl.getLength() != 1) {
            throw new MojoExecutionException("The expected number of items is 1, but " + nl.getLength() + " was found");
        }
        Node node = nl.item(0);
        return node.getTextContent();
    }

    private List<String> getStringsFromXML(File file, String path) throws MojoExecutionException {
        NodeList nl = this.getNodeListFromXml(file, path);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            result.add(node.getTextContent());
        }
        return result;
    }

    private NodeList getNodeListFromXml(File file, String path) throws MojoExecutionException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile(path);
            NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            return nl;
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error while reading XML file '" + file.getAbsolutePath() + "' with XPath='" + path + "'", ex);
        }
    }

    private Set<Dependency> collectGephiDependencies() throws MojoExecutionException {
        HashSet<Dependency> result = new HashSet<Dependency>();
        File modulesDir = new File(this.project.getBasedir(), "modules");
        if (!modulesDir.exists()) {
            throw new MojoExecutionException("The 'modules' folder doesn't exists at '" + modulesDir + "'");
        }
        File pomFile = new File(modulesDir, "pom.xml");
        if (!pomFile.exists()) {
            throw new MojoExecutionException("The 'pom.xml' file doesn't exists at '" + pomFile + "'");
        }
        NodeList nl = this.getNodeListFromXml(pomFile, "/project/dependencyManagement/dependencies/dependency");
        for (int i = 0; i < nl.getLength(); ++i) {
            String groupId = null;
            String artifactId = null;
            Node n = nl.item(i);
            NodeList children = n.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node m = children.item(j);
                if (m.getNodeName().equals("groupId")) {
                    groupId = m.getTextContent();
                    continue;
                }
                if (!m.getNodeName().equals("artifactId")) continue;
                artifactId = m.getTextContent();
            }
            if (groupId == null || artifactId == null) continue;
            if ("${project.groupId}".equals(groupId)) {
                groupId = "org.gephi";
            }
            result.add(new Dependency(groupId, artifactId));
            this.getLog().debug((CharSequence)("Found dependency groupId=" + groupId + " artifactId=" + artifactId));
        }
        return result;
    }

    private void insertDependencies(File xmlFile, Set<Dependency> dependencies) throws MojoExecutionException {
        try {
            Document doc = this.parseXMLDocument(xmlFile);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("/project/dependencies");
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (Dependency d : dependencies) {
                Element dep = doc.createElement("dependency");
                Element group = doc.createElement("groupId");
                Element artifact = doc.createElement("artifactId");
                group.appendChild(doc.createTextNode(d.groupId));
                artifact.appendChild(doc.createTextNode(d.artifactId));
                dep.appendChild(group);
                dep.appendChild(artifact);
                nodes.item(0).appendChild(dep);
            }
            FileWriter writer = new FileWriter(xmlFile);
            StreamResult result = new StreamResult(writer);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new DOMSource(doc), result);
            writer.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while inserting dependencies in XML document '" + xmlFile + "'", e);
        }
    }

    private void insertPublicPackages(File xmlFile, List<String> packages) throws MojoExecutionException {
        try {
            Document doc = this.parseXMLDocument(xmlFile);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("/project/build/plugins/plugin[artifactId = 'nbm-maven-plugin']/configuration/publicPackages");
            Node node = (Node)expr.evaluate(doc, XPathConstants.NODE);
            for (String p : packages) {
                Element pp = doc.createElement("publicPackage");
                pp.appendChild(doc.createTextNode(p));
                node.appendChild(pp);
            }
            FileWriter writer = new FileWriter(xmlFile);
            StreamResult result = new StreamResult(writer);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(doc), result);
            writer.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while inserting public packages in XML document '" + xmlFile + "'", e);
        }
    }

    private Document parseXMLDocument(File xmlFile) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setIgnoringComments(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.parse(xmlFile);
        return doc;
    }

    private void copyFiles(File srcFolder, File destFolder, String[] includes, String[] excludes) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(srcFolder);
        if (includes != null && includes.length >= 1) {
            scanner.setIncludes(includes);
        } else {
            scanner.setIncludes(new String[]{"**"});
        }
        if (excludes != null && excludes.length >= 1) {
            scanner.setExcludes(excludes);
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        List<String> files = Arrays.asList(scanner.getIncludedFiles());
        for (String name : files) {
            File source = new File(srcFolder, name);
            if (source.equals(srcFolder)) continue;
            File target = new File(destFolder, name);
            this.getLog().debug((CharSequence)("Copying file '" + source.getAbsolutePath() + "' to '" + target.getAbsolutePath() + "'"));
            FileUtils.copyFile((File)source, (File)target);
        }
    }

    private static class ProjectMetadata {
        private String brandingName;
        private String category;
        private String shortDescription;
        private String longDescription;
        private String author;
        private String homepageUrl;
        private String codeNameBase;
        private String localizingBundle;
        private List<String> publicPackages;
        private Set<Dependency> dependencies;
        private String licenseFile;

        private ProjectMetadata() {
        }
    }

    private static class Dependency {
        private final String groupId;
        private final String artifactId;

        public Dependency(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.groupId != null ? this.groupId.hashCode() : 0);
            hash = 37 * hash + (this.artifactId != null ? this.artifactId.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Dependency other = (Dependency)obj;
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            return !(this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId));
        }

        public String toString() {
            return "[groupId=" + this.groupId + " artifactId=" + this.artifactId + "]";
        }
    }
}

