/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.gephi.maven.json.Author;

public class MetadataUtils {
    protected static String getLicenseName(MavenProject project) {
        Xpp3Dom config;
        Plugin nbmPlugin = MetadataUtils.lookupNbmPlugin(project);
        if (nbmPlugin != null && (config = (Xpp3Dom)nbmPlugin.getConfiguration()) != null && config.getChild("licenseName") != null) {
            return config.getChild("licenseName").getValue();
        }
        return null;
    }

    protected static String getHomepage(MavenProject project) {
        Xpp3Dom config;
        Plugin nbmPlugin = MetadataUtils.lookupNbmPlugin(project);
        if (nbmPlugin != null && (config = (Xpp3Dom)nbmPlugin.getConfiguration()) != null && config.getChild("homePageUrl") != null) {
            return config.getChild("homePageUrl").getValue();
        }
        return null;
    }

    protected static List<Author> getAuthors(MavenProject project) {
        Xpp3Dom config;
        Plugin nbmPlugin = MetadataUtils.lookupNbmPlugin(project);
        if (nbmPlugin != null && (config = (Xpp3Dom)nbmPlugin.getConfiguration()) != null && config.getChild("author") != null) {
            String authorName = config.getChild("author").getValue();
            String authorEmail = config.getChild("authorEmail") != null ? config.getChild("authorEmail").getValue() : null;
            String authorUrl = config.getChild("authorUrl") != null ? config.getChild("authorUrl").getValue() : null;
            Author author = new Author();
            author.name = authorName;
            author.email = authorEmail;
            author.link = authorUrl;
            return Arrays.asList(author);
        }
        return null;
    }

    protected static Plugin lookupNbmPlugin(MavenProject project) {
        List plugins = project.getBuildPlugins();
        for (Plugin plugin : plugins) {
            if (!"org.codehaus.mojo:nbm-maven-plugin".equalsIgnoreCase(plugin.getKey())) continue;
            return plugin;
        }
        return null;
    }

    protected static String getReadme(MavenProject project, Log log) {
        File readmePath = new File(project.getBasedir(), "README.md");
        if (readmePath.exists()) {
            log.debug((CharSequence)("README.md file has been found: '" + readmePath.getAbsolutePath() + "'"));
            try {
                String line;
                StringBuilder builder = new StringBuilder();
                LineNumberReader fileReader = new LineNumberReader(new FileReader(readmePath));
                while ((line = fileReader.readLine()) != null) {
                    builder.append(line);
                    builder.append("\n");
                }
                log.info((CharSequence)("File README.md with " + builder.length() + " characters has been attached to project '" + project.getName() + "'"));
                return builder.toString();
            }
            catch (IOException ex) {
                log.error((CharSequence)"Error while reading README.md file", (Throwable)ex);
            }
        }
        return null;
    }

    protected static String getSourceCode(MavenProject project, Log log) {
        Xpp3Dom config;
        Plugin nbmPlugin = MetadataUtils.lookupNbmPlugin(project);
        if (nbmPlugin != null && (config = (Xpp3Dom)nbmPlugin.getConfiguration()) != null && config.getChild("sourceCodeUrl") != null) {
            return config.getChild("sourceCodeUrl").getValue();
        }
        Scm scm = project.getScm();
        if (scm != null && scm.getUrl() != null && !scm.getUrl().isEmpty()) {
            log.debug((CharSequence)("SCM configuration found, with url = '" + scm.getUrl() + "'"));
            return scm.getUrl();
        }
        return null;
    }

    protected static String getSourceCodeUrlFromGit(MavenProject project, Log log) {
        block9: {
            File gitPath = new File(project.getBasedir(), ".git");
            if (gitPath.exists() && gitPath.isDirectory()) {
                File gitPathConfig = new File(gitPath, "config");
                if (gitPathConfig.exists() && gitPathConfig.isFile()) {
                    log.debug((CharSequence)("Git config gile located at '" + gitPathConfig.getAbsolutePath() + "'"));
                    try {
                        String line;
                        BufferedReader fileReader = new BufferedReader(new FileReader(gitPathConfig));
                        Pattern pattern = Pattern.compile("\\s*url = (.*)");
                        String url = null;
                        while ((line = fileReader.readLine()) != null) {
                            Matcher m = pattern.matcher(line);
                            if (!m.matches()) continue;
                            url = m.group(1);
                            break;
                        }
                        fileReader.close();
                        if (url == null) break block9;
                        log.debug((CharSequence)("URL found in .git/config: '" + url + "'"));
                        if (url.startsWith("http://")) {
                            return url;
                        }
                        if (url.startsWith("git@")) {
                            Pattern gitPattern = Pattern.compile("git@([^:]*):([^.]*).git");
                            Matcher gitMatcher = gitPattern.matcher(url);
                            if (gitMatcher.matches()) {
                                String res = "http://" + gitMatcher.group(1) + "/" + gitMatcher.group(2);
                                log.debug((CharSequence)("Rewrote URL to '" + res + "'"));
                                return res;
                            }
                            break block9;
                        }
                        log.debug((CharSequence)("Couldn't find a pattern in the git URL: " + url));
                    }
                    catch (IOException e) {
                        log.error((CharSequence)"Error while reading Git config", (Throwable)e);
                    }
                }
            } else {
                log.debug((CharSequence)("The .git folder couldn't be found at '" + gitPath.getAbsolutePath() + "'"));
            }
        }
        return null;
    }
}

