/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.codehaus.mojo.nbm.utils.ExamineManifest;
import org.codehaus.plexus.util.IOUtil;
import org.gephi.maven.json.PluginMetadata;

public class ManifestUtils {
    protected static final String[] CATEGORIES = new String[]{"Layout", "Export", "Import", "Data Laboratory", "Filter", "Generator", "Metric", "Preview", "Tool", "Appearance", "Clustering", "Other Category"};
    private final Log log;
    private final String sourceManifestFile;

    public ManifestUtils(String sourceManifestFile, Log log) {
        this.sourceManifestFile = sourceManifestFile;
        this.log = log;
    }

    protected void checkManifestShowClientFalse(MavenProject proj) throws MojoExecutionException {
        Manifest manifest = this.getManifest(proj);
        Manifest.Section mainSection = manifest.getMainSection();
        String showInClient = mainSection.getAttributeValue("AutoUpdate-Show-In-Client");
        if (showInClient == null || showInClient.isEmpty() || !showInClient.equals("false")) {
            throw new MojoExecutionException("The manifest.mf file for project '" + proj.getName() + "' should contain a 'AutoUpdate-Show-In-Client' entry set at 'false'");
        }
    }

    protected void readManifestMetadata(MavenProject proj, PluginMetadata metadata) throws MojoExecutionException {
        Manifest manifest = this.getManifest(proj);
        Manifest.Section mainSection = manifest.getMainSection();
        String brandingName = mainSection.getAttributeValue("OpenIDE-Module-Name");
        String brandingShortDescription = mainSection.getAttributeValue("OpenIDE-Module-Short-Description");
        String brandingLongDescrption = mainSection.getAttributeValue("OpenIDE-Module-Long-Description");
        String brandingDisplayCategory = mainSection.getAttributeValue("OpenIDE-Module-Display-Category");
        if (mainSection.getAttribute("OpenIDE-Module-Localizing-Bundle") != null) {
            File folder = proj.getBasedir();
            String path = mainSection.getAttributeValue("OpenIDE-Module-Localizing-Bundle");
            File bundlerFile = new File(folder, "src" + File.separator + "main" + File.separator + "resources");
            if (!bundlerFile.exists()) {
                throw new MojoExecutionException("The 'src/main/resources' folder can't be found in '" + folder.getAbsolutePath() + "'");
            }
            if (!(bundlerFile = new File(bundlerFile, path.replace('/', File.separatorChar))).exists()) {
                throw new MojoExecutionException("The '" + path + "' file can't be found");
            }
            Properties prop = new Properties();
            FileReader bundleReader = null;
            try {
                bundleReader = new FileReader(bundlerFile);
                prop.load(bundleReader);
                brandingName = prop.getProperty("OpenIDE-Module-Name", brandingName);
                brandingDisplayCategory = prop.getProperty("OpenIDE-Module-Display-Category", brandingDisplayCategory);
                brandingShortDescription = prop.getProperty("OpenIDE-Module-Short-Description", brandingShortDescription);
                brandingLongDescrption = prop.getProperty("OpenIDE-Module-Long-Description", brandingLongDescrption);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while reading '" + bundlerFile.getAbsolutePath() + "'", (Exception)e);
            }
            finally {
                if (bundleReader != null) {
                    try {
                        bundleReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (brandingName == null || brandingName.isEmpty()) {
            throw new MojoExecutionException("The manifest.mf file for project '" + proj.getName() + "' should contain a 'OpenIDE-Module-Name' entry");
        }
        if (brandingShortDescription == null || brandingShortDescription.isEmpty()) {
            throw new MojoExecutionException("The manifest.mf file for project '" + proj.getName() + "' should contain a 'OpenIDE-Module-Short-Description' entry");
        }
        if (brandingLongDescrption == null || brandingLongDescrption.isEmpty()) {
            throw new MojoExecutionException("The manifest.mf file for project '" + proj.getName() + "' should contain a 'OpenIDE-Module-Long-Description' entry");
        }
        if (brandingDisplayCategory == null || brandingDisplayCategory.isEmpty()) {
            throw new MojoExecutionException("The manifest.mf file for project '" + proj.getName() + "' should contain a 'OpenIDE-Module-Display-Category' entry");
        }
        if (!ManifestUtils.validateCategory(brandingDisplayCategory)) {
            throw new MojoExecutionException("The manifest entry 'OpenIDE-Module-Display-Category' is '" + brandingDisplayCategory + "' but should be one of the following values: " + Arrays.toString(CATEGORIES).replace("[", "").replace("]", ""));
        }
        metadata.name = brandingName;
        metadata.short_description = brandingShortDescription;
        metadata.long_description = brandingLongDescrption;
        metadata.category = brandingDisplayCategory;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Manifest getManifest(MavenProject proj) throws MojoExecutionException {
        File manifestFile = new File(proj.getBasedir(), this.sourceManifestFile);
        if (!manifestFile.exists()) {
            throw new MojoExecutionException("Cannot locate a manifest.mf file at " + manifestFile.getAbsolutePath() + " for project " + proj.getName());
        }
        ExamineManifest examinator = new ExamineManifest(this.log);
        examinator.setManifestFile(manifestFile);
        examinator.checkFile();
        Manifest manifest = null;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(new FileInputStream(manifestFile));
            manifest = new Manifest((Reader)reader);
        }
        catch (IOException exc) {
            try {
                throw new MojoExecutionException("Error reading manifest at " + manifestFile, (Exception)exc);
                catch (ManifestException ex) {
                    throw new MojoExecutionException("Error reading manifest at " + manifestFile, (Exception)((Object)ex));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return manifest;
    }

    protected static boolean validateCategory(String category) {
        HashSet<String> allowedCategories = new HashSet<String>(Arrays.asList(CATEGORIES));
        return allowedCategories.contains(category);
    }
}

