/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.gephi.maven.ManifestUtils;

public class GenerateUtils {
    protected static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);

    protected static VelocityEngine initVelocity() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        return ve;
    }

    protected static String validateDescription(String val) {
        return val != null && !val.isEmpty() ? val : null;
    }

    protected static String validatePomEntry(String val) {
        if (val != null) {
            if (!val.matches("[^><]+")) {
                System.err.println("The text can't contain '<' or '>' characters.");
            } else {
                return val;
            }
        }
        return null;
    }

    protected static String validateYesNoChoice(String val) {
        if (val != null && !val.isEmpty()) {
            if (!val.matches("(?i)y|n|yes|no")) {
                System.err.println("The answer should either be 'yes' or 'no'");
            } else {
                return val;
            }
        }
        return null;
    }

    protected static String validateCategory(String val) {
        if (val != null) {
            if (!ManifestUtils.validateCategory(val)) {
                System.err.println("The category should be one of the following options: " + Arrays.toString(ManifestUtils.CATEGORIES).replace("[", "").replace("]", ""));
            } else {
                return val;
            }
        }
        return null;
    }

    protected static String validateAuthor(String val) {
        if (val != null && !val.isEmpty()) {
            if (!val.matches("[^><]+")) {
                System.err.println("The author name contains invalid characters");
            } else {
                return val;
            }
        }
        return null;
    }

    protected static String validateAuthorUrl(String val) {
        if (val != null && !val.isEmpty()) {
            if (!val.matches("[^><]+")) {
                System.err.println("The author url contains invalid characters");
                return null;
            }
            return val;
        }
        return val;
    }

    protected static String validateAuthorEmail(String val) {
        if (val != null && !val.isEmpty()) {
            if (!VALID_EMAIL_ADDRESS_REGEX.matcher(val).find()) {
                System.err.println("The email format is not valid");
                return null;
            }
            return val;
        }
        return val;
    }

    protected static String validateFolderName(String val) {
        if (val != null) {
            if (!val.matches("[a-zA-Z0-9]+")) {
                System.err.println("The plugin folder name can't contain spaces or special characters");
            } else {
                return val;
            }
        }
        return null;
    }

    protected static String validateBrandingName(String val) {
        if (val != null) {
            if (!val.matches("[a-zA-Z0-9 -]+")) {
                System.err.println("The branding name should only contain regular characters.");
            } else {
                return val;
            }
        }
        return null;
    }

    protected static String validateOrganization(String val) {
        if (val != null) {
            if (!val.matches("[a-z0-9.-]+")) {
                System.err.println("The organization should only contain lowercase characters. The '.' and '-' characters are also allowed.");
            } else {
                return val;
            }
        }
        return null;
    }

    protected static String validateArtifact(String val) {
        if (val != null) {
            if (!val.matches("[a-z0-9-]+")) {
                System.err.println("The artifact should only contain lowercase characters or '-'. It' also recommended to end it with a '-plugin' suffix.");
            } else {
                return val;
            }
        }
        return null;
    }

    protected static String validateVersion(String val) {
        if (val != null) {
            if (!val.matches("[0-9]+\\.[0-9]+\\.[0-9]+")) {
                System.err.println("The version should match the semantic verisonning scheme: MAJOR.MINOR.PATCH (e.g. 1.0.1)");
            } else {
                return val;
            }
        }
        return null;
    }

    protected static String getPluginVersion(MavenProject project) {
        Set pluginArtifacts = project.getPluginArtifacts();
        for (Artifact artifact : pluginArtifacts) {
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            if (!groupId.equals("org.gephi") || !artifactId.equals("gephi-maven-plugin")) continue;
            return artifact.getVersion();
        }
        return null;
    }

    protected static void addModuleToPom(File pomFile, String moduleName, Log log) throws MojoExecutionException {
        try {
            String line;
            StringBuilder fileContent = new StringBuilder();
            BufferedReader reader = new BufferedReader(new FileReader(pomFile));
            String toAdd = "        <module>modules/" + moduleName + "</module>";
            boolean skip = false;
            while ((line = reader.readLine()) != null) {
                if (line.contains(toAdd)) {
                    log.debug((CharSequence)"Found the module path, skipping to avoid duplicate");
                    skip = true;
                }
                if (!skip && line.contains("</modules>")) {
                    fileContent.append(toAdd).append("\n");
                    log.debug((CharSequence)"Found '</modules>' string, inserting module path");
                }
                fileContent.append(line).append("\n");
            }
            reader.close();
            FileWriter writer = new FileWriter(pomFile);
            writer.append(fileContent.toString());
            writer.close();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error while reading/writing 'pom.xml' at '" + pomFile.getAbsolutePath() + "'", (Exception)ex);
        }
    }

    protected static void createManifest(File file, String branding, String shortDescription, String longDescription, String category) throws MojoExecutionException {
        GenerateUtils.createManifest(file, branding, shortDescription, longDescription, category, null);
    }

    protected static void createManifest(File file, String localizingBundle) throws MojoExecutionException {
        GenerateUtils.createManifest(file, null, null, null, null, localizingBundle);
    }

    protected static void createManifest(File file, String branding, String shortDescription, String longDescription, String category, String localizingBundle) throws MojoExecutionException {
        VelocityEngine ve = GenerateUtils.initVelocity();
        Template t = ve.getTemplate("org/gephi/maven/templates/plugin-manifest.mf", "UTF-8");
        VelocityContext context = new VelocityContext();
        context.put("branding_name", (Object)branding);
        context.put("short_description", (Object)shortDescription);
        context.put("long_description", (Object)longDescription);
        context.put("category", (Object)category);
        context.put("localizing_bundle", (Object)localizingBundle);
        try {
            FileWriter writer = new FileWriter(file);
            t.merge((Context)context, (Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing manifest.mf file", (Exception)e);
        }
    }

    protected static void createTopPomFile(File file, String gephiVersion, String orgId, String artifactId, String version, String brandingName, String authorName, String authorEmail, String authorUrl, String licenseName, String licenseFile, String sourceCodeUrl, String homepageUrl) throws MojoExecutionException {
        VelocityEngine ve = GenerateUtils.initVelocity();
        Template t = ve.getTemplate("org/gephi/maven/templates/top-plugin-pom.xml", "UTF-8");
        VelocityContext context = new VelocityContext();
        context.put("gephi_version", (Object)gephiVersion);
        context.put("org_id", (Object)orgId);
        context.put("artifact_id", (Object)artifactId);
        context.put("version", (Object)version);
        context.put("branding_name", (Object)brandingName);
        context.put("license_name", (Object)licenseName);
        context.put("license_file", (Object)licenseFile);
        context.put("author_name", (Object)authorName);
        context.put("author_email", (Object)authorEmail);
        context.put("author_url", (Object)authorUrl);
        context.put("sourcecode_url", (Object)sourceCodeUrl);
        context.put("homepage_url", (Object)homepageUrl);
        try {
            FileWriter writer = new FileWriter(file);
            t.merge((Context)context, (Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing pom.xml file", (Exception)e);
        }
    }

    protected static File createFolder(File folder, Log log) {
        if (folder.mkdirs()) {
            log.debug((CharSequence)("Created folder at '" + folder.getAbsolutePath() + "'"));
        }
        return folder;
    }
}

