/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Scanner;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.gephi.maven.GenerateUtils;
import org.gephi.maven.MetadataUtils;

@Mojo(name="generate", aggregator=true)
public class Generate
extends AbstractMojo {
    @Parameter(required=true, readonly=true, property="project")
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String readme;
        String longDescription;
        String shortDescription;
        String license;
        String authorUrl;
        String authorEmail;
        String author;
        String category;
        String branding;
        String folder;
        String version;
        String artifact;
        String org;
        File baseDir = this.project.getBasedir();
        this.getLog().info((CharSequence)"Start generating Gephi plugin configuration base. This process only creates things (does not delete anything).");
        this.getLog().info((CharSequence)"It's recommended to pull/merge the latest changes from the master branch before starting.");
        String gephiVersion = this.project.getProperties().getProperty("gephi.version");
        if (gephiVersion == null) {
            throw new MojoExecutionException("Can't obtain gephi version number");
        }
        this.getLog().info((CharSequence)("Gephi version is defined as '" + gephiVersion + "'"));
        File pomFile = new File(baseDir, "pom.xml");
        if (!pomFile.exists()) {
            throw new MojoExecutionException("The 'pom.xml' file doesn' exist at '" + pomFile.getAbsolutePath() + "'");
        }
        this.getLog().info((CharSequence)("Gephi Maven Plugin version: " + GenerateUtils.getPluginVersion(this.project)));
        Scanner input = new Scanner(System.in);
        this.getLog().info((CharSequence)"Please answer the following questions so the plugin can be configured. All values can be changed afterwards by editing the configuration files.\n");
        System.out.println("Configuration:");
        do {
            System.out.print("  Name of organization (e.g. my.company): ");
        } while ((org = GenerateUtils.validateOrganization(input.nextLine())) == null);
        do {
            System.out.print("  Name of artifact (e.g my-plugin): ");
        } while ((artifact = GenerateUtils.validateArtifact(input.nextLine())) == null);
        do {
            System.out.print("  Version (e.g. 1.0.0): ");
        } while ((version = GenerateUtils.validateVersion(input.nextLine())) == null);
        do {
            System.out.print("  Directory name (e.g MyPlugin): ");
        } while ((folder = GenerateUtils.validateFolderName(input.nextLine())) == null);
        do {
            System.out.print("  Branding name (e.g My Plugin): ");
        } while ((branding = GenerateUtils.validateBrandingName(input.nextLine())) == null);
        do {
            System.out.print("  Category (e.g Layout, Filter, etc.): ");
        } while ((category = GenerateUtils.validateCategory(input.nextLine())) == null);
        do {
            System.out.print("  Author: ");
        } while ((author = GenerateUtils.validateAuthor(input.nextLine())) == null);
        do {
            System.out.print("  Author email (optional): ");
        } while ((authorEmail = GenerateUtils.validateAuthorEmail(input.nextLine())) == null);
        do {
            System.out.print("  Author URL (optional): ");
        } while ((authorUrl = GenerateUtils.validateAuthorUrl(input.nextLine())) == null);
        do {
            System.out.print("  License (e.g Apache 2.0): ");
        } while ((license = GenerateUtils.validatePomEntry(input.nextLine())) == null);
        do {
            System.out.print("  Short description (i.e. one sentence): ");
        } while ((shortDescription = GenerateUtils.validateDescription(input.nextLine())) == null);
        do {
            System.out.print("  Long description (i.e multiple sentences): ");
        } while ((longDescription = GenerateUtils.validateDescription(input.nextLine())) == null);
        do {
            System.out.print("  Would you like to add a README.md file (yes|no): ");
        } while ((readme = GenerateUtils.validateYesNoChoice(input.nextLine())) == null);
        File pluginFolder = new File(baseDir, "modules" + File.separator + folder);
        if (pluginFolder.exists()) {
            String response;
            do {
                System.out.print("The plugin folder 'modules" + File.separator + folder + "' already exists, the configuration will be overriden, would you like to continue? (yes|no): ");
            } while ((response = GenerateUtils.validateYesNoChoice(input.nextLine())) == null);
            if (response.matches("(?i)n|no")) {
                this.getLog().warn((CharSequence)"Process aborted, nothing has been done");
                return;
            }
        } else {
            GenerateUtils.createFolder(new File(baseDir, "modules" + File.separator + folder), this.getLog());
        }
        input.close();
        String sourceCodeUrl = MetadataUtils.getSourceCodeUrlFromGit(this.project, this.getLog());
        this.getLog().debug((CharSequence)("Obtained source code url from Git: " + sourceCodeUrl));
        GenerateUtils.createTopPomFile(new File(pluginFolder, "pom.xml"), gephiVersion, org, artifact, version, branding, author, authorEmail, authorUrl, license, null, sourceCodeUrl, null);
        this.getLog().debug((CharSequence)("Created 'pom.xml' file at '" + pluginFolder.getAbsolutePath() + "'"));
        if (readme.matches("(?i)y|yes")) {
            this.createReadme(pluginFolder, branding);
            this.getLog().debug((CharSequence)("Created 'README.md' file at '" + pluginFolder.getAbsolutePath() + "'"));
        }
        File srcMain = GenerateUtils.createFolder(new File(pluginFolder, "src" + File.separator + "main"), this.getLog());
        File nbmFolder = GenerateUtils.createFolder(new File(srcMain, "nbm"), this.getLog());
        GenerateUtils.createFolder(new File(srcMain, "java"), this.getLog());
        GenerateUtils.createFolder(new File(srcMain, "resources"), this.getLog());
        GenerateUtils.createManifest(new File(nbmFolder, "manifest.mf"), branding, shortDescription, longDescription, category);
        this.getLog().debug((CharSequence)("Created 'manifest.mf' file at '" + nbmFolder.getAbsolutePath() + "'"));
        GenerateUtils.createFolder(new File(pluginFolder, "src" + File.separator + "img"), this.getLog());
        GenerateUtils.addModuleToPom(pomFile, folder, this.getLog());
        this.getLog().debug((CharSequence)("Inserted '" + folder + "' into the list of modules in 'pom.xml'"));
        this.getLog().info((CharSequence)("The configuration is successful. All values can be changed afterwards by editing the following configurations files:\n  - pom.xml: Module path listed in <modules></modules>, need to be updated if module folder is renamed\n  - modules" + File.separator + folder + File.separator + "pom.xml: Organization, version, name, author, license\n" + "  - modules" + File.separator + folder + File.separator + "src" + File.separator + "main" + File.separator + "nbm: Branding name, short description, long description, category"));
        this.getLog().info((CharSequence)"Finished.");
    }

    private void createReadme(File folder, String brandingName) throws MojoExecutionException {
        OutputStreamWriter writer = null;
        try {
            File readmeFile = new File(folder, "README.md");
            writer = new FileWriter(readmeFile);
            writer.append("## " + brandingName + "\n\n");
            writer.append("This README supports Markdown, see [syntax](https://help.github.com/articles/markdown-basics/)\n\n");
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error while writing 'README.md'", (Exception)ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

