/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.maven;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.mojo.nbm.utils.AbstractNetbeansMojo;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.gzip.GZipArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.netbeans.nbbuild.MakeUpdateDesc;

@Mojo(name="create-autoupdate", aggregator=true, defaultPhase=LifecyclePhase.PACKAGE)
public class CreateAutoUpdate
extends AbstractNetbeansMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}")
    protected File outputDirectory;
    @Parameter(required=true, readonly=true, property="project")
    private MavenProject project;
    @Parameter(required=true, readonly=true, property="reactorProjects")
    private List<MavenProject> reactorProjects;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String gephiVersion = (String)this.project.getProperties().get("gephi.version");
        if (gephiVersion == null) {
            throw new MojoExecutionException("The 'gephi.version' property should be defined");
        }
        File outputFolder = new File(this.outputDirectory, gephiVersion);
        if (outputFolder.mkdirs()) {
            this.getLog().debug((CharSequence)("Folder '" + outputFolder.getAbsolutePath() + "' created."));
        }
        if (this.reactorProjects != null && this.reactorProjects.size() > 0) {
            Project antProject = this.registerNbmAntTasks();
            for (MavenProject proj : this.reactorProjects) {
                if (!proj.getPackaging().equals("nbm")) continue;
                File moduleDir = proj.getFile().getParentFile();
                if (moduleDir != null && moduleDir.exists()) {
                    File targetDir = new File(moduleDir, "target");
                    if (targetDir.exists()) {
                        String gephiVersionModule = proj.getProperties().getProperty("gephi.version");
                        if (gephiVersionModule == null) {
                            throw new MojoExecutionException("The 'gephi.version' property should be defined in project '" + proj.getName() + "'");
                        }
                        if (gephiVersionModule.equals(gephiVersion)) {
                            File[] nbmsFiles;
                            for (File nbmFile : nbmsFiles = targetDir.listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File dir, String name) {
                                    return !name.startsWith(".") && name.endsWith(".nbm");
                                }
                            })) {
                                try {
                                    FileUtils.copyFileToDirectory((File)nbmFile, (File)outputFolder);
                                }
                                catch (IOException ex) {
                                    this.getLog().error((CharSequence)("Error while copying nbm file '" + nbmFile.getAbsolutePath() + "'"), (Throwable)ex);
                                }
                                this.getLog().info((CharSequence)("Copying  '" + nbmFile + "' to '" + outputFolder.getAbsolutePath() + "'"));
                            }
                            continue;
                        }
                        this.getLog().warn((CharSequence)("The NBM of module '" + proj.getName() + "' has been ignored because its 'gephi.version' is '" + gephiVersionModule + "' while '" + gephiVersion + "' is expected"));
                        continue;
                    }
                    this.getLog().error((CharSequence)("The module target dir for project '" + proj.getName() + "' doesn't exists"));
                    continue;
                }
                this.getLog().error((CharSequence)("The module dir for project '" + proj.getName() + "' doesn't exists"));
            }
            String fileName = "updates.xml";
            MakeUpdateDesc descTask = (MakeUpdateDesc)antProject.createTask("updatedist");
            File xmlFile = new File(outputFolder, fileName);
            descTask.setDesc(xmlFile);
            FileSet fs = new FileSet();
            fs.setDir(outputFolder);
            fs.createInclude().setName("**/*.nbm");
            descTask.addFileset(fs);
            try {
                descTask.execute();
            }
            catch (BuildException ex) {
                throw new MojoExecutionException("Cannot create autoupdate site xml file", (Exception)((Object)ex));
            }
            this.getLog().info((CharSequence)("Generated autoupdate site content at " + outputFolder.getAbsolutePath()));
            try {
                GZipArchiver gz = new GZipArchiver();
                gz.addFile(xmlFile, fileName);
                File gzipped = new File(outputFolder, fileName + ".gz");
                gz.setDestFile(gzipped);
                gz.createArchive();
            }
            catch (ArchiverException ex) {
                throw new MojoExecutionException("Cannot create gzipped version of the update site xml file.", (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Cannot create gzipped version of the update site xml file.", (Exception)ex);
            }
        }
        throw new MojoExecutionException("This should be executed on the reactor project");
        this.getLog().info((CharSequence)("Generated compressed autoupdate site content at " + outputFolder.getAbsolutePath()));
    }
}

