/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.maven;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.gephi.maven.ManifestUtils;
import org.gephi.maven.MetadataUtils;
import org.gephi.maven.ModuleUtils;
import org.gephi.maven.ScreenshotUtils;
import org.gephi.maven.json.PluginMetadata;
import org.gephi.maven.json.PluginsMetadata;
import org.gephi.maven.json.Version;

@Mojo(name="build-metadata", aggregator=true, defaultPhase=LifecyclePhase.SITE)
public class BuildMetadata
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}/site")
    protected File outputDirectory;
    @Parameter(required=true, defaultValue="src/main/nbm/manifest.mf")
    private String sourceManifestFile;
    @Parameter(required=true, readonly=true, property="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Parameter(required=true, readonly=true, property="project")
    private MavenProject project;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MMMMM d, yyyy");
    @Parameter(required=true)
    protected String metadataUrl;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String gephiVersion = (String)this.project.getProperties().get("gephi.version");
        if (gephiVersion == null) {
            throw new MojoExecutionException("The 'gephi.version' property should be defined");
        }
        this.getLog().debug((CharSequence)("Building metadata for 'gephi.version=" + gephiVersion + "'"));
        if (this.reactorProjects != null && this.reactorProjects.size() > 0) {
            PluginsMetadata pluginsMetadata;
            this.getLog().debug((CharSequence)("Found " + this.reactorProjects.size() + " projects in reactor"));
            ArrayList<MavenProject> modules = new ArrayList<MavenProject>();
            for (MavenProject proj : this.reactorProjects) {
                if (!proj.getPackaging().equals("nbm")) continue;
                String gephiVersionModule = proj.getProperties().getProperty("gephi.version");
                if (gephiVersionModule.equals(gephiVersion)) {
                    this.getLog().debug((CharSequence)("Found 'nbm' project '" + proj.getName() + "' with artifactId=" + proj.getArtifactId() + " and groupId=" + proj.getGroupId()));
                    modules.add(proj);
                    continue;
                }
                this.getLog().debug((CharSequence)("Ignored project '" + proj.getName() + "' based on 'gephi.version' value '" + gephiVersionModule + "'"));
            }
            ManifestUtils manifestUtils = new ManifestUtils(this.sourceManifestFile, this.getLog());
            Map<MavenProject, List<MavenProject>> tree = ModuleUtils.getModulesTree(modules, this.getLog());
            File pluginsJsonFile = new File(this.outputDirectory, "plugins.json");
            try {
                URL url = new URL(this.metadataUrl + "plugins.json");
                URLConnection connection = url.openConnection();
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                connection.connect();
                InputStream stream = connection.getInputStream();
                ReadableByteChannel rbc = Channels.newChannel(stream);
                FileOutputStream fos = new FileOutputStream(pluginsJsonFile);
                long read = fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                rbc.close();
                stream.close();
                this.getLog().debug((CharSequence)("Read " + read + "bytes from url '" + url + "' and write to '" + pluginsJsonFile.getAbsolutePath() + "'"));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error while downloading previous 'plugins.json'", e);
            }
            Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
            if (pluginsJsonFile.exists()) {
                try {
                    FileReader reader = new FileReader(pluginsJsonFile);
                    pluginsMetadata = (PluginsMetadata)gson.fromJson((Reader)reader, PluginsMetadata.class);
                    reader.close();
                    this.getLog().debug((CharSequence)"Read previous plugins.json file");
                }
                catch (JsonSyntaxException e) {
                    throw new MojoExecutionException("Error while reading previous 'plugins.json'", (Exception)((Object)e));
                }
                catch (JsonIOException e) {
                    throw new MojoExecutionException("Error while reading previous 'plugins.json'", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error while reading previous 'plugins.json'", (Exception)e);
                }
            } else {
                pluginsMetadata = new PluginsMetadata();
                pluginsMetadata.plugins = new ArrayList<PluginMetadata>();
                this.getLog().debug((CharSequence)"Create plugins.json");
            }
            for (Map.Entry<MavenProject, List<MavenProject>> entry : tree.entrySet()) {
                MavenProject topPlugin = entry.getKey();
                PluginMetadata pm = new PluginMetadata();
                pm.id = topPlugin.getArtifactId();
                boolean foundPrevious = false;
                for (PluginMetadata oldPm : pluginsMetadata.plugins) {
                    if (!oldPm.id.equals(pm.id)) continue;
                    pm = oldPm;
                    foundPrevious = true;
                    this.getLog().debug((CharSequence)("Found matching plugin id=" + pm.id + " in previous plugins.json"));
                    break;
                }
                manifestUtils.readManifestMetadata(topPlugin, pm);
                pm.license = MetadataUtils.getLicenseName(topPlugin);
                pm.authors = MetadataUtils.getAuthors(topPlugin);
                pm.last_update = this.dateFormat.format(new Date());
                pm.readme = MetadataUtils.getReadme(topPlugin, this.getLog());
                pm.images = ScreenshotUtils.copyScreenshots(topPlugin, new File(this.outputDirectory, "imgs" + File.separator + pm.id), "imgs" + File.separator + pm.id + "/", this.getLog());
                pm.homepage = MetadataUtils.getHomepage(topPlugin);
                pm.sourcecode = MetadataUtils.getSourceCode(topPlugin, this.getLog());
                if (pm.versions == null) {
                    pm.versions = new HashMap<String, Version>();
                }
                Version v = new Version();
                v.last_update = this.dateFormat.format(new Date());
                v.url = gephiVersion + "/" + ModuleUtils.getModuleDownloadPath(entry.getKey(), entry.getValue(), new File(this.outputDirectory, gephiVersion), this.getLog());
                pm.versions.put(gephiVersion, v);
                if (foundPrevious) continue;
                pluginsMetadata.plugins.add(pm);
            }
            String json = gson.toJson((Object)pluginsMetadata);
            try {
                FileWriter writer = new FileWriter(pluginsJsonFile);
                writer.append(json);
                writer.close();
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error while writing plugins.json file", (Exception)ex);
            }
        }
        throw new MojoExecutionException("The project should be a reactor project");
    }
}

