/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.vorbis.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.audio.OggAudioHeaders;
import org.gagravarr.ogg.audio.OggAudioStream;
import org.gagravarr.ogg.tools.OggAudioInfoTool;
import org.gagravarr.vorbis.VorbisFile;

public class VorbisInfoTool
extends OggAudioInfoTool {
    public static void main(String[] args) throws Exception {
        VorbisInfoTool.handleMain(args, new VorbisInfoTool());
    }

    public String getToolName() {
        return "VorbisInfoTool";
    }

    public String getDefaultExtension() {
        return "ogg";
    }

    public void process(File file, boolean debugging) throws IOException {
        OggAudioInfoTool.InfoPacketReader r = new OggAudioInfoTool.InfoPacketReader(new FileInputStream(file));
        VorbisFile vf = new VorbisFile((OggPacketReader)r);
        System.out.println("Processing file \"" + file + "\"");
        System.out.println("");
        System.out.println("Vorbis Headers:");
        System.out.println("  Version: " + vf.getInfo().getVersion());
        System.out.println("  Vendor: " + vf.getComment().getVendor());
        System.out.println("  Channels: " + vf.getInfo().getChannels());
        System.out.println("  Rate: " + vf.getInfo().getRate());
        System.out.println("");
        System.out.println("  Nominal Bitrate: " + vf.getInfo().getBitrateNominal());
        System.out.println("  Lower Bitrate: " + vf.getInfo().getBitrateLower());
        System.out.println("  Upper Bitrate: " + vf.getInfo().getBitrateUpper());
        System.out.println("");
        System.out.println("User Comments:");
        VorbisInfoTool.listTags((OggAudioHeaders)vf);
        System.out.println("");
        System.out.println("Vorbis Setup:");
        System.out.println("  Codebooks: " + vf.getSetup().getNumberOfCodebooks());
        System.out.println("");
        OggAudioInfoTool.InfoAudioStats stats = new OggAudioInfoTool.InfoAudioStats((OggAudioHeaders)vf, (OggAudioStream)vf, r.getLastSeqNum(), debugging);
        stats.calculate();
        System.out.println("");
        System.out.println("Vorbis Audio:");
        System.out.println("  Total Data Packets: " + stats.getAudioPacketsCount());
        System.out.println("  Total Data Length: " + stats.getAudioDataSize());
        System.out.println("  Audio Length Seconds: " + stats.getDurationSeconds());
        System.out.println("  Audio Length: " + stats.getDuration());
    }
}

