/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.opus.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.audio.OggAudioHeaders;
import org.gagravarr.ogg.tools.OggAudioInfoTool;
import org.gagravarr.opus.OpusFile;
import org.gagravarr.opus.OpusStatistics;

public class OpusInfoTool
extends OggAudioInfoTool {
    public static void main(String[] args) throws Exception {
        OpusInfoTool.handleMain(args, new OpusInfoTool());
    }

    public String getToolName() {
        return "OpusInfoTool";
    }

    public String getDefaultExtension() {
        return "opus";
    }

    public void process(File file, boolean debugging) throws IOException {
        OggAudioInfoTool.InfoPacketReader r = new OggAudioInfoTool.InfoPacketReader(new FileInputStream(file));
        OpusFile of = new OpusFile((OggPacketReader)r);
        System.out.println("Processing file \"" + file + "\"");
        System.out.println("");
        System.out.println("Opus Headers:");
        System.out.println("  Version: " + of.getInfo().getVersion());
        System.out.println("  Vendor: " + of.getTags().getVendor());
        System.out.println("  Channels: " + of.getInfo().getNumChannels());
        System.out.println("  Rate: " + of.getInfo().getRate() + "Hz");
        System.out.println("  Pre-Skip: " + of.getInfo().getPreSkip());
        System.out.println("  Playback Gain: " + of.getInfo().getOutputGain() + "dB");
        System.out.println("");
        System.out.println("User Comments:");
        OpusInfoTool.listTags((OggAudioHeaders)of);
        System.out.println("");
        OpusStatistics stats = new OpusStatistics(of);
        stats.calculate();
        System.out.println("");
        System.out.println("Opus Audio:");
        System.out.println("  Total Data Packets: " + stats.getAudioPacketsCount());
        System.out.println("  Total Data Length: " + stats.getAudioDataSize());
        System.out.println("  Audio Length Seconds: " + stats.getDurationSeconds());
        System.out.println("  Audio Length: " + stats.getDuration());
        System.out.println("  Packet duration: " + OpusInfoTool.format2(stats.getMaxPacketDuration()) + "ms (max), " + OpusInfoTool.format2(stats.getAvgPacketDuration()) + "ms (avg), " + OpusInfoTool.format2(stats.getMinPacketDuration()) + "ms (min)");
        System.out.println("  Page duration:   " + OpusInfoTool.format2(stats.getMaxPageDuration()) + "ms (max), " + OpusInfoTool.format2(stats.getAvgPageDuration()) + "ms (avg), " + OpusInfoTool.format2(stats.getMinPageDuration()) + "ms (min)");
        System.out.println("  Total data length: " + stats.getAudioDataSize() + " (overhead: " + OpusInfoTool.format1(stats.getOggOverheadPercentage()) + "%)");
        System.out.println("  Playback length: " + stats.getDuration());
        String cbr = "";
        if (stats.getMinPacketDuration() == stats.getMaxPacketDuration() && stats.getMinPacketBytes() == stats.getMaxPacketBytes()) {
            cbr = " (hard-CBR)";
        }
        System.out.println("  Average bitrate: " + OpusInfoTool.formatBitrate(stats.getAverageOverallBitrate()) + ", w/o overhead: " + OpusInfoTool.formatBitrate(stats.getAverageAudioBitrate()) + cbr);
    }
}

