/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.flac.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.gagravarr.flac.FlacAudioFrame;
import org.gagravarr.flac.FlacAudioSubFrame;
import org.gagravarr.flac.FlacFile;
import org.gagravarr.flac.FlacInfo;
import org.gagravarr.flac.FlacOggFile;
import org.gagravarr.flac.FlacTags;

public class FlacInfoTool {
    private FlacFile flac;
    private static final String SPACER = "  ";
    private static final String INDENT1 = "   ";
    private static final String INDENT2 = "      ";

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("   FlacInfoTool <file> [file] [file]");
            System.exit(1);
        }
        for (String f : args) {
            FlacInfoTool info = new FlacInfoTool(new File(f));
            info.printMetadataInfo();
            info.printFrameInfo();
            info.flac.close();
        }
    }

    public FlacInfoTool(File f) throws FileNotFoundException, IOException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.toString());
        }
        this.flac = FlacFile.open((File)f);
    }

    public void printMetadataInfo() throws IOException {
        if (this.flac instanceof FlacOggFile) {
            FlacOggFile ogg = (FlacOggFile)this.flac;
            System.out.println("FLAC-in-Ogg, in stream " + ogg.getSid());
        } else {
            System.out.println("FLAC Native");
        }
        FlacInfo info = this.flac.getInfo();
        System.out.println("   Min Block Size=" + info.getMinimumBlockSize());
        System.out.println("   Max Block Size=" + info.getMaximumBlockSize());
        System.out.println("   Min Frame Size=" + info.getMinimumFrameSize());
        System.out.println("   Max Frame Size=" + info.getMaximumFrameSize());
        System.out.println("   Num Channels=" + info.getNumChannels());
        System.out.println("   Bits Per Sample=" + info.getBitsPerSample());
        System.out.println("   Sample Rate=" + info.getSampleRate());
        System.out.println("   Num Samples=" + info.getNumberOfSamples());
        System.out.println("   Pre Skip=" + info.getPreSkip());
        FlacTags tags = this.flac.getTags();
        System.out.println(tags.getAllComments().size() + " Comments:");
        for (String tag : tags.getAllComments().keySet()) {
            System.out.println(INDENT1 + tag);
            for (String value : (List)tags.getAllComments().get(tag)) {
                System.out.println(INDENT2 + value);
            }
        }
        System.out.println();
    }

    public void printFrameInfo() throws IOException {
        FlacAudioFrame audio;
        int fn = -1;
        while ((audio = this.flac.getNextAudioPacket()) != null) {
            System.out.print("frame=" + ++fn);
            System.out.print(SPACER);
            System.out.print("offset=??");
            System.out.print(SPACER);
            System.out.print("bits=" + audio.getData().length * 8);
            System.out.print(SPACER);
            System.out.print("blocksize=" + audio.getBlockSize());
            System.out.print(SPACER);
            System.out.print("sample_rate=" + audio.getSampleRate());
            System.out.print(SPACER);
            System.out.print("channels=" + audio.getNumChannels());
            System.out.print(SPACER);
            System.out.print("channel_assignment=??");
            System.out.println();
            for (int sfn = 0; sfn < audio.getSubFrames().length; ++sfn) {
                FlacAudioSubFrame sf = audio.getSubFrames()[sfn];
                System.out.print(INDENT1);
                System.out.print("subframe=" + sfn);
                System.out.print(SPACER);
                System.out.print("wasted_bits=" + sf.getWastedBits());
                System.out.print(SPACER);
                System.out.print("type=" + sf.getType());
                System.out.print(SPACER);
                System.out.print("order=" + sf.getPredictorOrder());
                if (sf instanceof FlacAudioSubFrame.SubFrameLPC) {
                    FlacAudioSubFrame.SubFrameLPC sflpc = (FlacAudioSubFrame.SubFrameLPC)sf;
                    System.out.print(SPACER);
                    System.out.print("qlp_coeff_precision=" + sflpc.getLinearPredictorCoefficientPrecision());
                    System.out.print(SPACER);
                    System.out.print("quantization_level=" + sflpc.getLinearPredictorCoefficientShift());
                }
                if (sf instanceof FlacAudioSubFrame.SubFrameWithResidual) {
                    FlacAudioSubFrame.SubFrameWithResidual sfr = (FlacAudioSubFrame.SubFrameWithResidual)sf;
                    System.out.print(SPACER);
                    System.out.print("residual_type=" + sfr.getResidual().getType());
                    System.out.print(SPACER);
                    System.out.print("partition_order=" + sfr.getResidual().getPartitionOrder());
                    System.out.println();
                    if (sf instanceof FlacAudioSubFrame.SubFrameLPC) {
                        FlacAudioSubFrame.SubFrameLPC sflpc = (FlacAudioSubFrame.SubFrameLPC)sf;
                        for (int qc = 0; qc < sflpc.getCoefficients().length; ++qc) {
                            System.out.print(INDENT2);
                            System.out.print("qlp_coeff[" + qc + "]=" + sflpc.getCoefficients()[qc]);
                            System.out.println();
                        }
                    }
                    for (int wn = 0; wn < sfr.getWarmUpSamples().length; ++wn) {
                        System.out.print(INDENT2);
                        System.out.print("warmup[" + wn + "]=" + sfr.getWarmUpSamples()[wn]);
                        System.out.println();
                    }
                    for (int pn = 0; pn < sfr.getResidual().getNumPartitions(); ++pn) {
                        System.out.print(INDENT2);
                        System.out.print("parameter[" + pn + "]=" + sfr.getResidual().getRiceParams()[pn]);
                        System.out.println();
                    }
                    continue;
                }
                System.out.println();
            }
        }
    }
}

