/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.ogg.audio.OggAudioHeaders;
import org.gagravarr.theora.TheoraFile;
import org.gagravarr.theora.TheoraInfo;
import org.gagravarr.tika.OggAudioParser;
import org.gagravarr.vorbis.VorbisStyleComments;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TheoraParser
extends AbstractParser {
    private static final long serialVersionUID = -5459916822092342944L;
    protected static final MediaType THEORA_VIDEO = MediaType.parse((String)OggStreamIdentifier.THEORA_VIDEO.mimetype);
    private static List<MediaType> TYPES = Arrays.asList(THEORA_VIDEO);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return new HashSet<MediaType>(TYPES);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        metadata.set("Content-Type", THEORA_VIDEO.toString());
        metadata.set(XMPDM.VIDEO_COMPRESSOR, "Theora");
        OggFile ogg = new OggFile(stream);
        TheoraFile theora = new TheoraFile(ogg);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        if (theora.getSkeleton() != null) {
            // empty if block
        }
        this.extractInfo(metadata, theora.getInfo());
        OggAudioParser.extractComments(metadata, xhtml, (VorbisStyleComments)theora.getComments());
        for (OggAudioHeaders audio : theora.getSoundtracks()) {
        }
        xhtml.endDocument();
        theora.close();
    }

    protected void extractInfo(Metadata metadata, TheoraInfo info) throws TikaException {
        metadata.add("version", "Theora " + info.getVersion());
    }
}

