/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.lang;

import net.sf.retrotranslator.runtime.impl.WeakIdentityTable;
import net.sf.retrotranslator.runtime.java.lang._Thread_UncaughtExceptionHandler;

public class _Thread {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final WeakIdentityTable<Thread, _Thread> threads = new WeakIdentityTable<Thread, _Thread>(){

        @Override
        protected _Thread initialValue() {
            return new _Thread();
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.initialValue();
        }
    };
    private static Object defaultHandler;
    private volatile boolean started;
    private Object handler;

    public static void handleUncaughtException(Throwable throwable) {
        _Thread.processException(throwable);
    }

    protected static void processException(Throwable throwable) {
        if (new Exception().getStackTrace().length <= 4) {
            Thread thread = Thread.currentThread();
            Object handler = threads.obtain(thread).getHandler();
            if (handler == null) {
                handler = _Thread.getDefaultUncaughtExceptionHandler();
            }
            if (handler != null) {
                _Thread_UncaughtExceptionHandler.uncaughtException(handler, thread, throwable);
                return;
            }
        }
        try {
            throw throwable;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static AdvancedThreadBuilder createInstanceBuilder(ThreadGroup group, Runnable target, String name, long stackSize) {
        return new AdvancedThreadBuilder(group, RunnableWrapper.wrap(target), name, stackSize);
    }

    public static synchronized Object getDefaultUncaughtExceptionHandler() {
        return defaultHandler;
    }

    public static Object getUncaughtExceptionHandler(Thread thread) {
        Object handler = threads.obtain(thread).getHandler();
        return handler != null ? handler : thread.getThreadGroup();
    }

    private synchronized Object getHandler() {
        return this.handler;
    }

    public static void start(Thread thread) {
        thread.start();
        _Thread.threads.obtain((Thread)thread).started = true;
    }

    private static class RunnableWrapper
    implements Runnable {
        private Runnable target;

        private RunnableWrapper(Runnable target) {
            this.target = target;
        }

        public void run() {
            try {
                this.target.run();
            }
            catch (Throwable e) {
                _Thread.processException(e);
            }
        }

        protected static Runnable wrap(Runnable target) {
            return target == null || target instanceof RunnableWrapper ? target : new RunnableWrapper(target);
        }
    }

    public static class AdvancedThreadBuilder {
        private ThreadGroup group;
        private Runnable target;
        private String name;
        private long stackSize;

        protected AdvancedThreadBuilder(ThreadGroup group, Runnable target, String name, long stackSize) {
            this.group = group;
            this.target = target;
            this.name = name;
            this.stackSize = stackSize;
        }

        public ThreadGroup argument1() {
            return this.group;
        }

        public Runnable argument2() {
            return this.target;
        }

        public String argument3() {
            return this.name;
        }

        public long argument4() {
            return this.stackSize;
        }
    }
}

