/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.asm;

public class Type {
    public static final Type VOID_TYPE = new Type(0);
    public static final Type BOOLEAN_TYPE = new Type(1);
    public static final Type CHAR_TYPE = new Type(2);
    public static final Type BYTE_TYPE = new Type(3);
    public static final Type SHORT_TYPE = new Type(4);
    public static final Type INT_TYPE = new Type(5);
    public static final Type FLOAT_TYPE = new Type(6);
    public static final Type LONG_TYPE = new Type(7);
    public static final Type DOUBLE_TYPE = new Type(8);
    private final int sort;
    private char[] buf;
    private int off;
    private int len;

    private Type(int sort) {
        this.sort = sort;
        this.len = 1;
    }

    private Type(int sort, char[] buf, int off, int len) {
        this.sort = sort;
        this.buf = buf;
        this.off = off;
        this.len = len;
    }

    public static Type getType(String typeDescriptor) {
        return Type.getType(typeDescriptor.toCharArray(), 0);
    }

    public static Type[] getArgumentTypes(String methodDescriptor) {
        char car;
        char[] buf = methodDescriptor.toCharArray();
        int off = 1;
        int size = 0;
        while ((car = buf[off++]) != ')') {
            if (car == 'L') {
                while (buf[off++] != ';') {
                }
                ++size;
                continue;
            }
            if (car == '[') continue;
            ++size;
        }
        Type[] args = new Type[size];
        off = 1;
        size = 0;
        while (buf[off] != ')') {
            args[size] = Type.getType(buf, off);
            off += args[size].len;
            ++size;
        }
        return args;
    }

    private static Type getType(char[] buf, int off) {
        switch (buf[off]) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                int len = 1;
                while (buf[off + len] == '[') {
                    ++len;
                }
                if (buf[off + len] == 'L') {
                    ++len;
                    while (buf[off + len] != ';') {
                        ++len;
                    }
                }
                return new Type(9, buf, off, len + 1);
            }
        }
        int len = 1;
        while (buf[off + len] != ';') {
            ++len;
        }
        return new Type(10, buf, off, len + 1);
    }

    public int getSort() {
        return this.sort;
    }

    public int getDimensions() {
        int i = 1;
        while (this.buf[this.off + i] == '[') {
            ++i;
        }
        return i;
    }

    public Type getElementType() {
        return Type.getType(this.buf, this.off + this.getDimensions());
    }

    public String getClassName() {
        switch (this.sort) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                StringBuffer b = new StringBuffer(this.getElementType().getClassName());
                for (int i = this.getDimensions(); i > 0; --i) {
                    b.append("[]");
                }
                return b.toString();
            }
        }
        return new String(this.buf, this.off + 1, this.len - 2).replace('/', '.');
    }

    public String getInternalName() {
        return new String(this.buf, this.off + 1, this.len - 2);
    }

    public String getDescriptor() {
        StringBuffer buf = new StringBuffer();
        this.getDescriptor(buf);
        return buf.toString();
    }

    private void getDescriptor(StringBuffer buf) {
        switch (this.sort) {
            case 0: {
                buf.append('V');
                return;
            }
            case 1: {
                buf.append('Z');
                return;
            }
            case 2: {
                buf.append('C');
                return;
            }
            case 3: {
                buf.append('B');
                return;
            }
            case 4: {
                buf.append('S');
                return;
            }
            case 5: {
                buf.append('I');
                return;
            }
            case 6: {
                buf.append('F');
                return;
            }
            case 7: {
                buf.append('J');
                return;
            }
            case 8: {
                buf.append('D');
                return;
            }
        }
        buf.append(this.buf, this.off, this.len);
    }

    public static String getInternalName(Class c) {
        return c.getName().replace('.', '/');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Type)) {
            return false;
        }
        Type t = (Type)o;
        if (this.sort != t.sort) {
            return false;
        }
        if (this.sort == 10 || this.sort == 9) {
            if (this.len != t.len) {
                return false;
            }
            int i = this.off;
            int j = t.off;
            int end = i + this.len;
            while (i < end) {
                if (this.buf[i] != t.buf[j]) {
                    return false;
                }
                ++i;
                ++j;
            }
        }
        return true;
    }

    public int hashCode() {
        int hc = 13 * this.sort;
        if (this.sort == 10 || this.sort == 9) {
            int i;
            int end = i + this.len;
            for (i = this.off; i < end; ++i) {
                hc = 17 * (hc + this.buf[i]);
            }
        }
        return hc;
    }

    public String toString() {
        return this.getDescriptor();
    }
}

