/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.util;

import java.io.IOException;
import java.util.Locale;
import net.sf.retrotranslator.runtime.format.FormatContext;
import net.sf.retrotranslator.runtime.java.lang._Appendable;
import net.sf.retrotranslator.runtime.java.util.Formattable_;
import net.sf.retrotranslator.runtime.java.util.FormatterClosedException_;

public class Formatter_ {
    private Object out;
    private Locale locale;
    private IOException ioException;

    public Formatter_() {
        this(null, Locale.getDefault());
    }

    public Formatter_(Object a, Locale l) {
        this.out = a != null ? a : new StringBuffer();
        this.locale = l;
    }

    public String toString() {
        this.assertOpen();
        return this.out.toString();
    }

    public Formatter_ format(String format, Object[] args) {
        return this.format(this.locale, format, args);
    }

    public Formatter_ format(Locale locale, String format, Object[] args) {
        this.assertOpen();
        new FormatterContext(locale).printf(format, args);
        return this;
    }

    private void assertOpen() {
        if (this.out == null) {
            throw new FormatterClosedException_();
        }
    }

    private class FormatterContext
    extends FormatContext {
        public FormatterContext(Locale locale) {
            super(locale);
        }

        public void append(char c) {
            try {
                _Appendable.append(Formatter_.this.out, c);
            }
            catch (IOException e) {
                Formatter_.this.ioException = e;
            }
        }

        public void append(String s) {
            try {
                _Appendable.append(Formatter_.this.out, s);
            }
            catch (IOException e) {
                Formatter_.this.ioException = e;
            }
        }

        public void append(String s, int start, int end) {
            try {
                _Appendable.append(Formatter_.this.out, s, start, end);
            }
            catch (IOException e) {
                Formatter_.this.ioException = e;
            }
        }

        public boolean writeFormattable() {
            if (!(this.getArgument() instanceof Formattable_)) {
                return false;
            }
            Formatter_ formatter = Formatter_.this;
            if (this.getLocale() != formatter.locale) {
                formatter = new Formatter_(Formatter_.this.out, this.getLocale());
            }
            int formatFlags = 0;
            if (this.isFlag('-')) {
                formatFlags |= 1;
            }
            if (this.isUpperCase()) {
                formatFlags |= 2;
            }
            if (this.isFlag('#')) {
                formatFlags |= 4;
            }
            ((Formattable_)this.getArgument()).formatTo(formatter, formatFlags, this.getWidth(), this.getPrecision());
            return true;
        }
    }
}

