/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.fusesource.hawtdispatch.CustomDispatchSource;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;
import org.fusesource.hawtdispatch.EventAggregators;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.ServiceBase;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportListener;

public class TcpTransport
extends ServiceBase
implements Transport {
    static InetAddress localhost;
    protected URI remoteLocation;
    protected URI localLocation;
    protected TransportListener listener;
    protected ProtocolCodec codec;
    protected SocketChannel channel;
    protected SocketState socketState = new DISCONNECTED();
    protected DispatchQueue dispatchQueue;
    private DispatchSource readSource;
    private DispatchSource writeSource;
    protected CustomDispatchSource<Integer, Integer> drainOutboundSource;
    protected CustomDispatchSource<Integer, Integer> yieldSource;
    protected boolean useLocalHost = true;
    int maxReadRate;
    int maxWriteRate;
    int receiveBufferSize = 65536;
    int sendBufferSize = 65536;
    boolean closeOnCancel = true;
    boolean keepAlive = true;
    int trafficClass = 8;
    protected RateLimitingChannel rateLimitingChannel;
    SocketAddress localAddress;
    SocketAddress remoteAddress;
    protected Executor blockingExecutor;
    private final Task CANCEL_HANDLER = new Task(){

        public void run() {
            TcpTransport.this.socketState.onCanceled();
        }
    };
    boolean rejectingOffers;
    boolean writeResumedForCodecFlush = false;
    static /* synthetic */ Class class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED;
    static /* synthetic */ Class class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTING;

    public static synchronized InetAddress getLocalHost() throws UnknownHostException {
        if (localhost == null) {
            localhost = InetAddress.getLocalHost();
        }
        return localhost;
    }

    protected void initializeChannel() throws Exception {
        this.channel.configureBlocking(false);
        Socket socket = this.channel.socket();
        try {
            socket.setReuseAddress(true);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setSoLinger(true, 0);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setTrafficClass(this.trafficClass);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setKeepAlive(this.keepAlive);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setSendBufferSize(this.sendBufferSize);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (this.channel != null && this.codec != null) {
            this.initializeCodec();
        }
    }

    protected void initializeCodec() throws Exception {
        this.codec.setTransport(this);
    }

    public void connecting(URI remoteLocation, URI localLocation) throws Exception {
        this.channel = SocketChannel.open();
        this.initializeChannel();
        this.remoteLocation = remoteLocation;
        this.localLocation = localLocation;
        this.socketState = new CONNECTING();
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue queue) {
        this.dispatchQueue = queue;
        if (this.readSource != null) {
            this.readSource.setTargetQueue(queue);
        }
        if (this.writeSource != null) {
            this.writeSource.setTargetQueue(queue);
        }
        if (this.drainOutboundSource != null) {
            this.drainOutboundSource.setTargetQueue(queue);
        }
        if (this.yieldSource != null) {
            this.yieldSource.setTargetQueue(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _start(Task task) {
        try {
            Class<?> clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTING;
            if (clazz == null) {
                clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTING = new CONNECTING[0].getClass().getComponentType();
            }
            if (this.socketState.is((Class<? extends SocketState>)clazz)) {
                this.blockingExecutor.execute(new Runnable(){

                    public void run() {
                        try {
                            final InetSocketAddress localAddress = TcpTransport.this.localLocation != null ? new InetSocketAddress(InetAddress.getByName(TcpTransport.this.localLocation.getHost()), TcpTransport.this.localLocation.getPort()) : null;
                            String host = TcpTransport.this.resolveHostName(TcpTransport.this.remoteLocation.getHost());
                            final InetSocketAddress remoteAddress = new InetSocketAddress(host, TcpTransport.this.remoteLocation.getPort());
                            TcpTransport.this.dispatchQueue.execute(new Task(){
                                static /* synthetic */ Class class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTING;

                                public void run() {
                                    SocketState socketState = TcpTransport.this.socketState;
                                    Class<?> clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTING;
                                    if (clazz == null) {
                                        clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTING = new CONNECTING[0].getClass().getComponentType();
                                    }
                                    if (!socketState.is((Class<? extends SocketState>)clazz)) {
                                        return;
                                    }
                                    try {
                                        if (localAddress != null) {
                                            TcpTransport.this.channel.socket().bind(localAddress);
                                        }
                                        TcpTransport.this.trace("connecting...");
                                        TcpTransport.this.channel.connect(remoteAddress);
                                        TcpTransport.this.readSource = Dispatch.createSource(TcpTransport.this.channel, 8, TcpTransport.this.dispatchQueue);
                                        TcpTransport.this.readSource.setEventHandler(new Task(){

                                            public void run() {
                                                if (TcpTransport.this.getServiceState() != ServiceBase.STARTED) {
                                                    return;
                                                }
                                                try {
                                                    TcpTransport.this.trace("connected.");
                                                    TcpTransport.this.channel.finishConnect();
                                                    TcpTransport.this.readSource.setCancelHandler(null);
                                                    TcpTransport.this.readSource.cancel();
                                                    TcpTransport.this.readSource = null;
                                                    TcpTransport.this.socketState = new CONNECTED();
                                                    TcpTransport.this.onConnected();
                                                }
                                                catch (IOException e) {
                                                    TcpTransport.this.onTransportFailure(e);
                                                }
                                            }
                                        });
                                        TcpTransport.this.readSource.setCancelHandler(TcpTransport.this.CANCEL_HANDLER);
                                        TcpTransport.this.readSource.resume();
                                    }
                                    catch (IOException iOException) {
                                        try {
                                            TcpTransport.this.channel.close();
                                        }
                                        catch (IOException iOException2) {
                                            // empty catch block
                                        }
                                        TcpTransport.this.socketState = new CANCELED(true);
                                        TcpTransport.this.listener.onTransportFailure(iOException);
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            try {
                                TcpTransport.this.channel.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            TcpTransport.this.socketState = new CANCELED(true);
                            TcpTransport.this.listener.onTransportFailure(e);
                        }
                    }
                });
            } else {
                Class<?> clazz2 = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED;
                if (clazz2 == null) {
                    clazz2 = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED = new CONNECTED[0].getClass().getComponentType();
                }
                if (this.socketState.is((Class<? extends SocketState>)clazz2)) {
                    this.dispatchQueue.execute(new Task(){

                        public void run() {
                            try {
                                TcpTransport.this.trace("was connected.");
                                TcpTransport.this.onConnected();
                            }
                            catch (IOException e) {
                                TcpTransport.this.onTransportFailure(e);
                            }
                        }
                    });
                } else {
                    System.err.println("cannot be started.  socket state is: " + this.socketState);
                }
            }
        }
        finally {
            if (task != null) {
                task.run();
            }
        }
    }

    public void _stop(Task task) {
        this.trace("stopping.. at state: " + this.socketState);
        this.socketState.onStop(task);
    }

    protected String resolveHostName(String string) throws UnknownHostException {
        String string2 = TcpTransport.getLocalHost().getHostName();
        if (string2 != null && this.isUseLocalHost() && string2.equals(string)) {
            return "localhost";
        }
        return string;
    }

    protected void onConnected() throws IOException {
        this.yieldSource = Dispatch.createSource(EventAggregators.INTEGER_ADD, this.dispatchQueue);
        this.yieldSource.setEventHandler(new Task(){

            public void run() {
                TcpTransport.this.drainInbound();
            }
        });
        this.yieldSource.resume();
        this.drainOutboundSource = Dispatch.createSource(EventAggregators.INTEGER_ADD, this.dispatchQueue);
        this.drainOutboundSource.setEventHandler(new Task(){

            public void run() {
                TcpTransport.this.flush();
            }
        });
        this.drainOutboundSource.resume();
        this.readSource = Dispatch.createSource(this.channel, 1, this.dispatchQueue);
        this.writeSource = Dispatch.createSource(this.channel, 4, this.dispatchQueue);
        this.readSource.setCancelHandler(this.CANCEL_HANDLER);
        this.writeSource.setCancelHandler(this.CANCEL_HANDLER);
        this.readSource.setEventHandler(new Task(){

            public void run() {
                TcpTransport.this.drainInbound();
            }
        });
        this.writeSource.setEventHandler(new Task(){

            public void run() {
                TcpTransport.this.flush();
            }
        });
        if (this.maxReadRate != 0 || this.maxWriteRate != 0) {
            this.rateLimitingChannel = new RateLimitingChannel();
            this.schedualRateAllowanceReset();
        }
        this.listener.onTransportConnected();
    }

    private void schedualRateAllowanceReset() {
        this.dispatchQueue.executeAfter(1L, TimeUnit.SECONDS, new Task(){
            static /* synthetic */ Class class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED;

            public void run() {
                SocketState socketState = TcpTransport.this.socketState;
                Class<?> clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED;
                if (clazz == null) {
                    clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED = new CONNECTED[0].getClass().getComponentType();
                }
                if (!socketState.is((Class<? extends SocketState>)clazz)) {
                    return;
                }
                TcpTransport.this.rateLimitingChannel.resetAllowance();
                TcpTransport.this.schedualRateAllowanceReset();
            }
        });
    }

    private void dispose() {
        if (this.readSource != null) {
            this.readSource.cancel();
            this.readSource = null;
        }
        if (this.writeSource != null) {
            this.writeSource.cancel();
            this.writeSource = null;
        }
        this.codec = null;
    }

    public void onTransportFailure(IOException error) {
        this.listener.onTransportFailure(error);
        this.socketState.onCanceled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean full() {
        if (this.codec == null) return true;
        if (this.codec.full()) return true;
        Class<?> clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED;
        if (clazz == null) {
            clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED = new CONNECTED[0].getClass().getComponentType();
        }
        if (!this.socketState.is((Class<? extends SocketState>)clazz)) return true;
        if (this.getServiceState() == STARTED) return false;
        return true;
    }

    public boolean offer(Object command) {
        this.dispatchQueue.assertExecuting();
        if (this.full()) {
            return false;
        }
        try {
            ProtocolCodec.BufferState rc = this.codec.write(command);
            this.rejectingOffers = this.codec.full();
            switch (10.$SwitchMap$org$fusesource$hawtdispatch$transport$ProtocolCodec$BufferState[rc.ordinal()]) {
                case 1: {
                    return false;
                }
            }
            this.drainOutboundSource.merge(_Integer.valueOf(1));
        }
        catch (IOException e) {
            this.onTransportFailure(e);
        }
        return true;
    }

    public void flush() {
        block12: {
            block11: {
                this.dispatchQueue.assertExecuting();
                if (this.getServiceState() != STARTED) break block11;
                Class<?> clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED;
                if (clazz == null) {
                    clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED = new CONNECTED[0].getClass().getComponentType();
                }
                if (this.socketState.is((Class<? extends SocketState>)clazz)) break block12;
            }
            return;
        }
        try {
            if (this.codec.flush() == ProtocolCodec.BufferState.EMPTY && this.transportFlush()) {
                if (this.writeResumedForCodecFlush) {
                    this.writeResumedForCodecFlush = false;
                    this.suspendWrite();
                }
                this.rejectingOffers = false;
                this.listener.onRefill();
            } else if (!this.writeResumedForCodecFlush) {
                this.writeResumedForCodecFlush = true;
                this.resumeWrite();
            }
        }
        catch (IOException iOException) {
            this.onTransportFailure(iOException);
        }
    }

    protected boolean transportFlush() throws IOException {
        return true;
    }

    public void drainInbound() {
        if (!this.getServiceState().isStarted() || this.readSource.isSuspended()) {
            return;
        }
        try {
            long l = this.codec.getReadCounter();
            while (this.codec.getReadCounter() - l < (long)(this.codec.getReadBufferSize() << 2)) {
                Object object = this.codec.read();
                if (object != null) {
                    try {
                        this.listener.onTransportCommand(object);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        this.onTransportFailure(new IOException("Transport listener failure."));
                    }
                    if (this.getServiceState() != STOPPED && !this.readSource.isSuspended()) continue;
                    return;
                }
                return;
            }
            this.yieldSource.merge(_Integer.valueOf(1));
        }
        catch (IOException iOException) {
            this.onTransportFailure(iOException);
        }
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void suspendRead() {
        if (this.isConnected() && this.readSource != null) {
            this.readSource.suspend();
        }
    }

    public void resumeRead() {
        if (this.isConnected() && this.readSource != null) {
            if (this.rateLimitingChannel != null) {
                this.rateLimitingChannel.resumeRead();
            } else {
                this._resumeRead();
            }
        }
    }

    private void _resumeRead() {
        this.readSource.resume();
        this.dispatchQueue.execute(new Task(){

            public void run() {
                TcpTransport.this.drainInbound();
            }
        });
    }

    protected void suspendWrite() {
        if (this.isConnected() && this.writeSource != null) {
            this.writeSource.suspend();
        }
    }

    protected void resumeWrite() {
        if (this.isConnected() && this.writeSource != null) {
            this.writeSource.resume();
        }
    }

    public void setTransportListener(TransportListener transportListener) {
        this.listener = transportListener;
    }

    public ProtocolCodec getProtocolCodec() {
        return this.codec;
    }

    public void setProtocolCodec(ProtocolCodec protocolCodec) throws Exception {
        this.codec = protocolCodec;
        if (this.channel != null && this.codec != null) {
            this.initializeCodec();
        }
    }

    public boolean isConnected() {
        Class<?> clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED;
        if (clazz == null) {
            clazz = class$org$fusesource$hawtdispatch$transport$TcpTransport$CONNECTED = new CONNECTED[0].getClass().getComponentType();
        }
        return this.socketState.is((Class<? extends SocketState>)clazz);
    }

    public boolean isClosed() {
        return this.getServiceState() == STOPPED;
    }

    public boolean isUseLocalHost() {
        return this.useLocalHost;
    }

    public void setUseLocalHost(boolean useLocalHost) {
        this.useLocalHost = useLocalHost;
    }

    private void trace(String message) {
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    public ReadableByteChannel getReadChannel() {
        if (this.rateLimitingChannel != null) {
            return this.rateLimitingChannel;
        }
        return this.channel;
    }

    public WritableByteChannel getWriteChannel() {
        if (this.rateLimitingChannel != null) {
            return this.rateLimitingChannel;
        }
        return this.channel;
    }

    public void setMaxReadRate(int maxReadRate) {
        this.maxReadRate = maxReadRate;
    }

    public void setMaxWriteRate(int maxWriteRate) {
        this.maxWriteRate = maxWriteRate;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        if (this.channel != null) {
            try {
                this.channel.socket().setReceiveBufferSize(receiveBufferSize);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
        if (this.channel != null) {
            try {
                this.channel.socket().setReceiveBufferSize(sendBufferSize);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }

    static class 10 {
        static final /* synthetic */ int[] $SwitchMap$org$fusesource$hawtdispatch$transport$ProtocolCodec$BufferState;

        static {
            $SwitchMap$org$fusesource$hawtdispatch$transport$ProtocolCodec$BufferState = new int[ProtocolCodec.BufferState.values().length];
            try {
                10.$SwitchMap$org$fusesource$hawtdispatch$transport$ProtocolCodec$BufferState[ProtocolCodec.BufferState.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    class RateLimitingChannel
    implements ReadableByteChannel,
    WritableByteChannel {
        int read_allowance;
        boolean read_suspended;
        int read_resume_counter;
        int write_allowance;
        boolean write_suspended;

        RateLimitingChannel() {
            this.read_allowance = TcpTransport.this.maxReadRate;
            this.read_suspended = false;
            this.read_resume_counter = 0;
            this.write_allowance = TcpTransport.this.maxWriteRate;
            this.write_suspended = false;
        }

        public void resetAllowance() {
            if (this.read_allowance != TcpTransport.this.maxReadRate || this.write_allowance != TcpTransport.this.maxWriteRate) {
                this.read_allowance = TcpTransport.this.maxReadRate;
                this.write_allowance = TcpTransport.this.maxWriteRate;
                if (this.write_suspended) {
                    this.write_suspended = false;
                    TcpTransport.this.resumeWrite();
                }
                if (this.read_suspended) {
                    this.read_suspended = false;
                    this.resumeRead();
                    for (int i = 0; i < this.read_resume_counter; ++i) {
                        this.resumeRead();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(ByteBuffer dst) throws IOException {
            if (TcpTransport.this.maxReadRate == 0) {
                return TcpTransport.this.channel.read(dst);
            }
            int remaining = dst.remaining();
            if (this.read_allowance == 0 || remaining == 0) {
                return 0;
            }
            int reduction = 0;
            if (remaining > this.read_allowance) {
                reduction = remaining - this.read_allowance;
                dst.limit(dst.limit() - reduction);
            }
            int rc = 0;
            try {
                rc = TcpTransport.this.channel.read(dst);
                this.read_allowance -= rc;
            }
            finally {
                if (reduction != 0) {
                    if (dst.remaining() == 0) {
                        TcpTransport.this.readSource.suspend();
                        this.read_suspended = true;
                    }
                    dst.limit(dst.limit() + reduction);
                }
            }
            return rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(ByteBuffer src) throws IOException {
            if (TcpTransport.this.maxWriteRate == 0) {
                return TcpTransport.this.channel.write(src);
            }
            int remaining = src.remaining();
            if (this.write_allowance == 0 || remaining == 0) {
                return 0;
            }
            int reduction = 0;
            if (remaining > this.write_allowance) {
                reduction = remaining - this.write_allowance;
                src.limit(src.limit() - reduction);
            }
            int rc = 0;
            try {
                rc = TcpTransport.this.channel.write(src);
                this.write_allowance -= rc;
            }
            finally {
                if (reduction != 0) {
                    if (src.remaining() == 0) {
                        this.write_suspended = true;
                        TcpTransport.this.suspendWrite();
                    }
                    src.limit(src.limit() + reduction);
                }
            }
            return rc;
        }

        public boolean isOpen() {
            return TcpTransport.this.channel.isOpen();
        }

        public void close() throws IOException {
            TcpTransport.this.channel.close();
        }

        public void resumeRead() {
            if (this.read_suspended) {
                ++this.read_resume_counter;
            } else {
                TcpTransport.this._resumeRead();
            }
        }
    }

    class CANCELED
    extends SocketState {
        private boolean disposed;

        public CANCELED(boolean disposed) {
            this.disposed = disposed;
        }

        void onStop(Task onCompleted) {
            TcpTransport.this.trace("CANCELED.onStop");
            if (!this.disposed) {
                this.disposed = true;
                TcpTransport.this.dispose();
            }
            onCompleted.run();
        }
    }

    class CANCELING
    extends SocketState {
        private LinkedList<Task> runnables = new LinkedList();
        private int remaining;
        private boolean dispose;

        public CANCELING() {
            if (TcpTransport.this.readSource != null) {
                ++this.remaining;
                TcpTransport.this.readSource.cancel();
            }
            if (TcpTransport.this.writeSource != null) {
                ++this.remaining;
                TcpTransport.this.writeSource.cancel();
            }
        }

        void onStop(Task onCompleted) {
            TcpTransport.this.trace("CANCELING.onCompleted");
            this.add(onCompleted);
            this.dispose = true;
        }

        void add(Task onCompleted) {
            if (onCompleted != null) {
                this.runnables.add(onCompleted);
            }
        }

        void onCanceled() {
            TcpTransport.this.trace("CANCELING.onCanceled");
            --this.remaining;
            if (this.remaining != 0) {
                return;
            }
            try {
                if (TcpTransport.this.closeOnCancel) {
                    TcpTransport.this.channel.close();
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
            TcpTransport.this.socketState = new CANCELED(this.dispose);
            Iterator i$ = this.runnables.iterator();
            while (i$.hasNext()) {
                Task runnable = (Task)i$.next();
                runnable.run();
            }
            if (this.dispose) {
                TcpTransport.this.dispose();
            }
        }
    }

    class CONNECTED
    extends SocketState {
        public CONNECTED() {
            TcpTransport.this.localAddress = TcpTransport.this.channel.socket().getLocalSocketAddress();
            TcpTransport.this.remoteAddress = TcpTransport.this.channel.socket().getRemoteSocketAddress();
        }

        void onStop(Task onCompleted) {
            TcpTransport.this.trace("CONNECTED.onStop");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.add(this.createDisconnectTask());
            state.onStop(onCompleted);
        }

        void onCanceled() {
            TcpTransport.this.trace("CONNECTED.onCanceled");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.add(this.createDisconnectTask());
            state.onCanceled();
        }

        Task createDisconnectTask() {
            return new Task(){

                public void run() {
                    TcpTransport.this.listener.onTransportDisconnected();
                }
            };
        }
    }

    class CONNECTING
    extends SocketState {
        CONNECTING() {
        }

        void onStop(Task onCompleted) {
            TcpTransport.this.trace("CONNECTING.onStop");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.onStop(onCompleted);
        }

        void onCanceled() {
            TcpTransport.this.trace("CONNECTING.onCanceled");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.onCanceled();
        }
    }

    static class DISCONNECTED
    extends SocketState {
        DISCONNECTED() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class SocketState {
        SocketState() {
        }

        void onStop(Task onCompleted) {
        }

        void onCanceled() {
        }

        boolean is(Class<? extends SocketState> clazz) {
            return this.getClass() == clazz;
        }
    }
}

