/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import net.sf.retrotranslator.runtime.java.lang._Thread;

public class Executors {
    public static ThreadFactory defaultThreadFactory() {
        return new DefaultThreadFactory();
    }

    public static Callable callable(Runnable task, Object result) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(task, result);
    }

    private Executors() {
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            _Thread.AdvancedThreadBuilder advancedThreadBuilder = _Thread.createInstanceBuilder(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            Thread t = new Thread(advancedThreadBuilder.argument1(), advancedThreadBuilder.argument2(), advancedThreadBuilder.argument3(), advancedThreadBuilder.argument4());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    static final class RunnableAdapter
    implements Callable {
        final Runnable task;
        final Object result;

        RunnableAdapter(Runnable task, Object result) {
            this.task = task;
            this.result = result;
        }

        public Object call() {
            this.task.run();
            return this.result;
        }
    }
}

