/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.helpers;

public abstract class WaitQueue {
    public abstract void insert(WaitNode var1);

    public abstract WaitNode extract();

    public static class WaitNode {
        boolean waiting = true;
        WaitNode next = null;
        final Thread owner = Thread.currentThread();

        public Thread getOwner() {
            return this.owner;
        }

        public synchronized boolean signal(QueuedSync sync) {
            boolean signalled = this.waiting;
            if (signalled) {
                this.waiting = false;
                this.notify();
                sync.takeOver(this);
            }
            return signalled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void doWaitUninterruptibly(QueuedSync sync) {
            if (!sync.recheck(this)) {
                boolean wasInterrupted = Thread.interrupted();
                try {
                    while (this.waiting) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            wasInterrupted = true;
                        }
                    }
                }
                finally {
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    public static interface QueuedSync {
        public boolean recheck(WaitNode var1);

        public void takeOver(WaitNode var1);
    }
}

