/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentLinkedQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.LinkedList;
import net.sf.retrotranslator.runtime.java.lang.ThreadLocal_;
import net.sf.retrotranslator.runtime.java.lang._Thread;
import net.sf.retrotranslator.runtime.java.lang._Thread_UncaughtExceptionHandler;
import net.sf.retrotranslator.runtime.java.util._LinkedList;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.internal.AbstractDispatchObject;
import org.fusesource.hawtdispatch.internal.ActiveMetricsCollector;
import org.fusesource.hawtdispatch.internal.HawtDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.InactiveMetricsCollector;
import org.fusesource.hawtdispatch.internal.MetricsCollector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialDispatchQueue
extends AbstractDispatchObject
implements Runnable,
HawtDispatchQueue {
    protected volatile String label;
    protected final AtomicBoolean triggered = new AtomicBoolean();
    protected final ConcurrentLinkedQueue<Runnable> externalQueue = new ConcurrentLinkedQueue();
    private final LinkedList<Runnable> localQueue = new LinkedList();
    private final LinkedList<Runnable> sourceQueue = new LinkedList();
    private final ThreadLocal_<Boolean> executing = new ThreadLocal_();
    private MetricsCollector metricsCollector = InactiveMetricsCollector.INSTANCE;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$fusesource$hawtdispatch$internal$SerialDispatchQueue;

    public SerialDispatchQueue(String label) {
        this.label = label;
    }

    @Override
    public void execute(Runnable runnable) {
        if (!$assertionsDisabled && runnable == null) {
            throw new AssertionError();
        }
        this.enqueue(this.metricsCollector.track(runnable));
    }

    @Override
    public LinkedList<Runnable> getSourceQueue() {
        return this.sourceQueue;
    }

    private void enqueue(Runnable runnable) {
        if (this.executing.get() != null) {
            this.localQueue.add(runnable);
        } else {
            this.externalQueue.add((Object)runnable);
            this.triggerExecution();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        original = (HawtDispatchQueue)HawtDispatcher.CURRENT_QUEUE.get();
        HawtDispatcher.CURRENT_QUEUE.set((Object)this);
        this.executing.set((Object)Boolean.TRUE);
        try {
            while ((runnable = (Runnable)this.externalQueue.poll()) != null) {
                this.localQueue.add(runnable);
            }
lbl9:
            // 3 sources

            while (true) {
                if (this.isSuspended()) {
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (Throwable var5_9) {
            for (Runnable runnable : this.sourceQueue) {
                runnable.run();
            }
            this.sourceQueue.clear();
            this.executing.remove();
            HawtDispatcher.CURRENT_QUEUE.set((Object)original);
            this.triggered.set(false);
            v0 = empty = this.externalQueue.isEmpty() != false && this.localQueue.isEmpty() != false;
            if (!this.isSuspended() && !empty) {
                this.triggerExecution();
            }
            throw var5_9;
        }
        for (Runnable runnable : this.sourceQueue) {
            runnable.run();
        }
        this.sourceQueue.clear();
        this.executing.remove();
        HawtDispatcher.CURRENT_QUEUE.set((Object)original);
        this.triggered.set(false);
        v1 = empty = this.externalQueue.isEmpty() != false && this.localQueue.isEmpty() != false;
        if (!this.isSuspended() && !empty) {
            this.triggerExecution();
        }
        return;
lbl-1000:
        // 1 sources

        {
            runnable = (Runnable)_LinkedList.poll(this.localQueue);
            if (runnable != null) ** GOTO lbl-1000
        }
        for (Runnable runnable : this.sourceQueue) {
            runnable.run();
        }
        this.sourceQueue.clear();
        this.executing.remove();
        HawtDispatcher.CURRENT_QUEUE.set((Object)original);
        this.triggered.set(false);
        v2 = empty = this.externalQueue.isEmpty() != false && this.localQueue.isEmpty() != false;
        if (!this.isSuspended() && !empty) {
            this.triggerExecution();
        }
        return;
lbl-1000:
        // 1 sources

        {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                thread = Thread.currentThread();
                _Thread_UncaughtExceptionHandler.uncaughtException(_Thread.getUncaughtExceptionHandler(thread), thread, e);
                ** continue;
            }
        }
    }

    protected void triggerExecution() {
        if (this.triggered.compareAndSet(false, true)) {
            this.getTargetQueue().execute(this);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean isExecuting() {
        return this.executing.get() != null;
    }

    @Override
    public void assertExecuting() {
        if (!$assertionsDisabled && !this.isExecuting()) {
            throw new AssertionError((Object)this.getDispatcher().assertMessage());
        }
    }

    @Override
    protected void onStartup() {
        this.triggerExecution();
    }

    @Override
    protected void onResume() {
        this.triggerExecution();
    }

    @Override
    public DispatchQueue.QueueType getQueueType() {
        return DispatchQueue.QueueType.SERIAL_QUEUE;
    }

    @Override
    public void executeAfter(long delay, TimeUnit unit, Runnable runnable) {
        this.getDispatcher().timerThread.addRelative(runnable, this, delay, unit);
    }

    @Override
    public HawtDispatcher getDispatcher() {
        HawtDispatchQueue target = this.getTargetQueue();
        if (target == null) {
            throw new UnsupportedOperationException();
        }
        return target.getDispatcher();
    }

    public void profile(boolean on) {
        if (!on && this.metricsCollector == InactiveMetricsCollector.INSTANCE) {
            return;
        }
        if (on) {
            this.metricsCollector = new ActiveMetricsCollector(this);
            this.getDispatcher().track(this);
        } else {
            this.metricsCollector = InactiveMetricsCollector.INSTANCE;
        }
    }

    public String toString() {
        if (this.label == null) {
            return "serial queue";
        }
        return new StringBuffer().append("serial queue { label: \"").append(this.label).append("\" }").toString();
    }

    static {
        Class<?> clazz = class$org$fusesource$hawtdispatch$internal$SerialDispatchQueue;
        if (clazz == null) {
            clazz = class$org$fusesource$hawtdispatch$internal$SerialDispatchQueue = new SerialDispatchQueue[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

