/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.util.BaseOutputWriter;
import com.googlecode.jmxtrans.util.JmxUtils;
import com.googlecode.jmxtrans.util.ValidationException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.KeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GangliaWriter
extends BaseOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(GangliaWriter.class);
    private static final String DEFAULT_UNITS = "";
    private static final int DEFAULT_TMAX = 60;
    private static final int DEFAULT_DMAX = 0;
    private static final int DEFAULT_PORT = 8649;
    private static final int BUFFER_SIZE = 1500;
    public static final String GROUP_NAME = "groupName";
    protected byte[] buffer = new byte[1500];
    protected int offset;
    private Map<String, KeyedObjectPool> poolMap;
    private KeyedObjectPool pool;
    private InetSocketAddress address;
    private String groupName;

    public GangliaWriter() {
        this.poolMap = JmxUtils.getDefaultPoolMap();
    }

    public GangliaWriter(Map<String, KeyedObjectPool> poolMap) {
        this.poolMap = poolMap;
    }

    @Override
    public void validateSetup(Query query) throws ValidationException {
        Integer port = 8649;
        String host = (String)this.getSettings().get("host");
        Object portObj = this.getSettings().get("port");
        if (portObj instanceof String) {
            port = Integer.parseInt((String)portObj);
        } else if (portObj instanceof Integer) {
            port = (Integer)portObj;
        }
        if (host == null) {
            throw new ValidationException("Host can't be null", query);
        }
        this.groupName = (String)this.getSettings().get(GROUP_NAME);
        this.address = new InetSocketAddress(host, (int)port);
        this.pool = this.poolMap.get(Server.DATAGRAM_SOCKET_FACTORY_POOL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWrite(Query query) throws Exception {
        DatagramSocket socket = (DatagramSocket)this.pool.borrowObject((Object)this.address);
        try {
            List<String> typeNames = this.getTypeNames();
            String spoofedHostname = null;
            spoofedHostname = StringUtils.isNotEmpty((String)query.getServer().getAlias()) ? query.getServer().getAlias() : query.getServer().getHost();
            for (Result result : query.getResults()) {
                Map<String, Object> resultValues;
                if (this.isDebugEnabled()) {
                    log.debug(result.toString());
                }
                if ((resultValues = result.getValues()) == null) continue;
                for (Map.Entry<String, Object> values : resultValues.entrySet()) {
                    if (!JmxUtils.isNumeric(values.getValue())) continue;
                    this.emitMetric(socket, spoofedHostname, JmxUtils.getKeyString2(query, result, values, typeNames, null), "int32", values.getValue().toString());
                }
            }
        }
        finally {
            this.pool.returnObject((Object)this.address, (Object)socket);
        }
    }

    protected void emitMetric(DatagramSocket socket, String hostName, String name, String type, String value) throws IOException {
        if (name == null) {
            log.warn("Metric was emitted with no name.");
            return;
        }
        if (value == null) {
            log.warn("Metric name " + name + " was emitted with a null value.");
            return;
        }
        if (type == null) {
            log.warn("Metric name " + name + ", value " + value + " has no type.");
            return;
        }
        hostName = "x:" + hostName;
        this.offset = 0;
        this.xdr_int(128);
        this.xdr_string(hostName);
        this.xdr_string(name);
        this.xdr_int(1);
        this.xdr_string(type);
        this.xdr_string(name);
        this.xdr_string(DEFAULT_UNITS);
        this.xdr_int(3);
        this.xdr_int(60);
        this.xdr_int(0);
        if (StringUtils.isNotEmpty((String)this.groupName)) {
            this.xdr_int(1);
            this.xdr_string("GROUP");
            this.xdr_string(this.groupName);
        } else {
            this.xdr_int(0);
        }
        DatagramPacket packet = new DatagramPacket(this.buffer, this.offset, this.address);
        socket.send(packet);
        this.offset = 0;
        this.xdr_int(133);
        this.xdr_string(hostName);
        this.xdr_string(name);
        this.xdr_int(1);
        this.xdr_string("%s");
        this.xdr_string(value);
        packet = new DatagramPacket(this.buffer, this.offset, this.address);
        socket.send(packet);
        log.debug("Emitting metric " + name + ", type " + type + ", value " + value + " for host: " + hostName);
    }

    protected void xdr_string(String s) {
        byte[] bytes = s.getBytes();
        int len = bytes.length;
        this.xdr_int(len);
        System.arraycopy(bytes, 0, this.buffer, this.offset, len);
        this.offset += len;
        this.pad();
    }

    private void pad() {
        int newOffset = (this.offset + 3) / 4 * 4;
        while (this.offset < newOffset) {
            this.buffer[this.offset++] = 0;
        }
    }

    protected void xdr_int(int i) {
        this.buffer[this.offset++] = (byte)(i >> 24 & 0xFF);
        this.buffer[this.offset++] = (byte)(i >> 16 & 0xFF);
        this.buffer[this.offset++] = (byte)(i >> 8 & 0xFF);
        this.buffer[this.offset++] = (byte)(i & 0xFF);
    }
}

