/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.googlecode.jmxtrans.OutputWriter;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.util.PropertyResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(value={"obj", "attr", "typeNames", "resultAlias", "keys", "outputWriters"})
public class Query {
    private Server server;
    private String obj;
    private List<String> attr;
    private String resultAlias;
    private List<String> keys;
    private List<OutputWriter> outputWriters;
    private List<Result> results;
    private Set<String> typeNames;

    public Query() {
    }

    public Query(String obj) {
        this.obj = obj;
    }

    public Query(String obj, String attr) {
        this.obj = obj;
        this.addAttr(attr);
    }

    public Query(String obj, List<String> attr) {
        this.obj = obj;
        this.attr = attr;
    }

    public void setObj(String obj) {
        this.obj = PropertyResolver.resolveProps(obj);
    }

    public String getObj() {
        return this.obj;
    }

    public void setResultAlias(String resultAlias) {
        this.resultAlias = resultAlias;
    }

    public String getResultAlias() {
        return this.resultAlias;
    }

    public void setTypeNames(Set<String> typeNames) {
        this.typeNames = typeNames;
    }

    public Set<String> getTypeNames() {
        return this.typeNames;
    }

    public void setAttr(List<String> attr) {
        this.attr = attr;
        PropertyResolver.resolveList(this.attr);
    }

    public List<String> getAttr() {
        return this.attr;
    }

    public void addAttr(String attr) {
        if (this.attr == null) {
            this.attr = new ArrayList<String>();
        }
        this.attr.add(attr);
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
        PropertyResolver.resolveList(this.keys);
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void addKey(String key) {
        if (this.keys == null) {
            this.keys = new ArrayList<String>();
        }
        this.keys.add(key);
    }

    public void setResults(List<Result> results) {
        this.results = results;
    }

    @JsonIgnore
    public List<Result> getResults() {
        return this.results;
    }

    public void setOutputWriters(List<OutputWriter> outputWriters) {
        this.outputWriters = outputWriters;
    }

    public List<OutputWriter> getOutputWriters() {
        return this.outputWriters;
    }

    public void addOutputWriter(OutputWriter writer) {
        if (this.outputWriters == null) {
            this.outputWriters = new ArrayList<OutputWriter>();
        }
        this.outputWriters.add(writer);
    }

    @JsonIgnore
    public void setServer(Server server) {
        this.server = server;
    }

    @JsonIgnore
    public Server getServer() {
        return this.server;
    }

    public String toString() {
        return "Query [obj=" + this.obj + ", resultAlias=" + this.resultAlias + ", attr=" + this.attr + "]";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        int sizeL = 0;
        int sizeR = 0;
        if (this.getOutputWriters() != null) {
            sizeL = this.getOutputWriters().size();
        }
        if (other.getOutputWriters() != null) {
            sizeR = other.getOutputWriters().size();
        }
        return new EqualsBuilder().append((Object)this.getObj(), (Object)other.getObj()).append(this.getKeys(), other.getKeys()).append(this.getAttr(), other.getAttr()).append((Object)this.getResultAlias(), (Object)other.getResultAlias()).append(sizeL, sizeR).isEquals();
    }

    public int hashCode() {
        int sizeL = 0;
        if (this.getOutputWriters() != null) {
            sizeL = this.getOutputWriters().size();
        }
        return new HashCodeBuilder(41, 97).append((Object)this.getObj()).append(this.getKeys()).append(this.getAttr()).append((Object)this.getResultAlias()).append(sizeL).toHashCode();
    }
}

