/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.example.stomp;

import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public interface Stomp {
    public static final Buffer EMPTY_BUFFER = new Buffer(0);
    public static final byte NULL = 0;
    public static final Buffer NULL_BUFFER = new Buffer(new byte[]{0});
    public static final byte NEWLINE = 10;
    public static final Buffer NEWLINE_BUFFER = new Buffer(new byte[]{10});
    public static final Buffer END_OF_FRAME_BUFFER = new Buffer(new byte[]{0, 10});
    public static final AsciiBuffer TRUE = new AsciiBuffer("true");
    public static final AsciiBuffer FALSE = new AsciiBuffer("false");

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Transformations {
        JMS_BYTE,
        JMS_OBJECT_XML,
        JMS_OBJECT_JSON,
        JMS_MAP_XML,
        JMS_MAP_JSON;


        public String toString() {
            return this.name().replaceAll("_", "-").toLowerCase();
        }

        public static Transformations getValue(String value) {
            return Transformations.valueOf(value.replaceAll("-", "_").toUpperCase());
        }
    }

    public static interface Headers {
        public static final byte SEPERATOR = 58;
        public static final Buffer SEPERATOR_BUFFER = new Buffer(new byte[]{58});
        public static final AsciiBuffer RECEIPT_REQUESTED = new AsciiBuffer("receipt");
        public static final AsciiBuffer TRANSACTION = new AsciiBuffer("transaction");
        public static final AsciiBuffer CONTENT_LENGTH = new AsciiBuffer("content-length");
        public static final AsciiBuffer TRANSFORMATION = new AsciiBuffer("transformation");
        public static final AsciiBuffer TRANSFORMATION_ERROR = new AsciiBuffer("transformation-error");

        public static interface Ack {
            public static final AsciiBuffer MESSAGE_ID = new AsciiBuffer("message-id");
        }

        public static interface Connected {
            public static final AsciiBuffer SESSION = new AsciiBuffer("session");
            public static final AsciiBuffer RESPONSE_ID = new AsciiBuffer("response-id");
        }

        public static interface Error {
            public static final AsciiBuffer MESSAGE = new AsciiBuffer("message");
        }

        public static interface Connect {
            public static final AsciiBuffer LOGIN = new AsciiBuffer("login");
            public static final AsciiBuffer PASSCODE = new AsciiBuffer("passcode");
            public static final AsciiBuffer CLIENT_ID = new AsciiBuffer("client-id");
            public static final AsciiBuffer REQUEST_ID = new AsciiBuffer("request-id");
        }

        public static interface Unsubscribe {
            public static final AsciiBuffer DESTINATION = new AsciiBuffer("destination");
            public static final AsciiBuffer ID = new AsciiBuffer("id");
        }

        public static interface Subscribe {
            public static final AsciiBuffer DESTINATION = new AsciiBuffer("destination");
            public static final AsciiBuffer ACK_MODE = new AsciiBuffer("ack");
            public static final AsciiBuffer ID = new AsciiBuffer("id");
            public static final AsciiBuffer SELECTOR = new AsciiBuffer("selector");

            public static interface AckModeValues {
                public static final AsciiBuffer AUTO = new AsciiBuffer("auto");
                public static final AsciiBuffer CLIENT = new AsciiBuffer("client");
                public static final AsciiBuffer INDIVIDUAL = new AsciiBuffer("client-individual");
            }
        }

        public static interface Message {
            public static final AsciiBuffer MESSAGE_ID = new AsciiBuffer("message-id");
            public static final AsciiBuffer DESTINATION = new AsciiBuffer("destination");
            public static final AsciiBuffer CORRELATION_ID = new AsciiBuffer("correlation-id");
            public static final AsciiBuffer EXPIRATION_TIME = new AsciiBuffer("expires");
            public static final AsciiBuffer REPLY_TO = new AsciiBuffer("reply-to");
            public static final AsciiBuffer PRORITY = new AsciiBuffer("priority");
            public static final AsciiBuffer REDELIVERED = new AsciiBuffer("redelivered");
            public static final AsciiBuffer TIMESTAMP = new AsciiBuffer("timestamp");
            public static final AsciiBuffer TYPE = new AsciiBuffer("type");
            public static final AsciiBuffer SUBSCRIPTION = new AsciiBuffer("subscription");
        }

        public static interface Send {
            public static final AsciiBuffer DESTINATION = new AsciiBuffer("destination");
            public static final AsciiBuffer CORRELATION_ID = new AsciiBuffer("correlation-id");
            public static final AsciiBuffer REPLY_TO = new AsciiBuffer("reply-to");
            public static final AsciiBuffer EXPIRATION_TIME = new AsciiBuffer("expires");
            public static final AsciiBuffer PRIORITY = new AsciiBuffer("priority");
            public static final AsciiBuffer TYPE = new AsciiBuffer("type");
            public static final AsciiBuffer PERSISTENT = new AsciiBuffer("persistent");
        }

        public static interface Response {
            public static final AsciiBuffer RECEIPT_ID = new AsciiBuffer("receipt-id");
        }
    }

    public static interface Responses {
        public static final AsciiBuffer CONNECTED = new AsciiBuffer("CONNECTED");
        public static final AsciiBuffer ERROR = new AsciiBuffer("ERROR");
        public static final AsciiBuffer MESSAGE = new AsciiBuffer("MESSAGE");
        public static final AsciiBuffer RECEIPT = new AsciiBuffer("RECEIPT");
    }

    public static interface Commands {
        public static final AsciiBuffer CONNECT = new AsciiBuffer("CONNECT");
        public static final AsciiBuffer SEND = new AsciiBuffer("SEND");
        public static final AsciiBuffer DISCONNECT = new AsciiBuffer("DISCONNECT");
        public static final AsciiBuffer SUBSCRIBE = new AsciiBuffer("SUBSCRIBE");
        public static final AsciiBuffer UNSUBSCRIBE = new AsciiBuffer("UNSUBSCRIBE");
        public static final AsciiBuffer BEGIN_TRANSACTION = new AsciiBuffer("BEGIN");
        public static final AsciiBuffer COMMIT_TRANSACTION = new AsciiBuffer("COMMIT");
        public static final AsciiBuffer ABORT_TRANSACTION = new AsciiBuffer("ABORT");
        public static final AsciiBuffer BEGIN = new AsciiBuffer("BEGIN");
        public static final AsciiBuffer COMMIT = new AsciiBuffer("COMMIT");
        public static final AsciiBuffer ABORT = new AsciiBuffer("ABORT");
        public static final AsciiBuffer ACK = new AsciiBuffer("ACK");
    }
}

