/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.F2;
import fj.Ord;
import fj.P;
import fj.P2;
import fj.P3;
import fj.control.parallel.Promise;
import fj.data.Array;
import fj.data.IterableW;
import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Set;
import fj.data.Stream;
import fj.data.Tree;
import fj.data.TreeZipper;
import fj.data.Zipper;

public final class F2Functions {
    private F2Functions() {
    }

    public static <A, B, C> F<B, C> f(F2<A, B, C> f, A a) {
        return b -> f.f(a, b);
    }

    public static <A, B, C> F<A, F<B, C>> curry(F2<A, B, C> f) {
        return a -> b -> f.f(a, b);
    }

    public static <A, B, C> F2<B, A, C> flip(F2<A, B, C> f) {
        return (b, a) -> f.f(a, b);
    }

    public static <A, B, C> F<P2<A, B>, C> tuple(F2<A, B, C> f) {
        return p -> f.f(p._1(), p._2());
    }

    public static <A, B, C> F2<Array<A>, Array<B>, Array<C>> arrayM(F2<A, B, C> f) {
        return (a, b) -> a.bind(b, F2Functions.curry(f));
    }

    public static <A, B, C> F2<Promise<A>, Promise<B>, Promise<C>> promiseM(F2<A, B, C> f) {
        return (a, b) -> a.bind(b, F2Functions.curry(f));
    }

    public static <A, B, C> F2<Iterable<A>, Iterable<B>, IterableW<C>> iterableM(F2<A, B, C> f) {
        return (a, b) -> IterableW.liftM2(F2Functions.curry(f)).f((Iterable<Iterable>)a).f((Iterable)b);
    }

    public static <A, B, C> F2<List<A>, List<B>, List<C>> listM(F2<A, B, C> f) {
        return (a, b) -> List.liftM2(F2Functions.curry(f)).f((List<List>)a).f((List)b);
    }

    public static <A, B, C> F2<NonEmptyList<A>, NonEmptyList<B>, NonEmptyList<C>> nelM(F2<A, B, C> f) {
        return (as, bs) -> NonEmptyList.fromList(as.toList().bind(bs.toList(), f)).some();
    }

    public static <A, B, C> F2<Option<A>, Option<B>, Option<C>> optionM(F2<A, B, C> f) {
        return (a, b) -> Option.liftM2(F2Functions.curry(f)).f((Option<Option>)a).f((Option)b);
    }

    public static <A, B, C> F2<Set<A>, Set<B>, Set<C>> setM(F2<A, B, C> f, Ord<C> o) {
        return (as, bs) -> {
            Set cs = Set.empty(o);
            for (Object a : as) {
                for (Object b : bs) {
                    cs = cs.insert(f.f(a, b));
                }
            }
            return cs;
        };
    }

    public static <A, B, C> F2<Stream<A>, Stream<B>, Stream<C>> streamM(F2<A, B, C> f) {
        return (as, bs) -> as.bind(bs, f);
    }

    public static <A, B, C> F2<Tree<A>, Tree<B>, Tree<C>> treeM(final F2<A, B, C> f) {
        return new F2<Tree<A>, Tree<B>, Tree<C>>(){

            @Override
            public Tree<C> f(Tree<A> as, Tree<B> bs) {
                1 self = this;
                return Tree.node(f.f(as.root(), bs.root()), P.lazy(() -> F2Functions.streamM(self).f(as.subForest()._1(), bs.subForest()._1())));
            }
        };
    }

    public static <A, B, C> F2<Array<A>, Array<B>, Array<C>> zipArrayM(F2<A, B, C> f) {
        return (as, bs) -> as.zipWith(bs, f);
    }

    public static <A, B, C> F2<Iterable<A>, Iterable<B>, Iterable<C>> zipIterableM(F2<A, B, C> f) {
        return (as, bs) -> IterableW.wrap(as).zipWith(bs, f);
    }

    public static <A, B, C> F2<List<A>, List<B>, List<C>> zipListM(F2<A, B, C> f) {
        return (as, bs) -> as.zipWith(bs, f);
    }

    public static <A, B, C> F2<Stream<A>, Stream<B>, Stream<C>> zipStreamM(F2<A, B, C> f) {
        return (as, bs) -> as.zipWith(bs, f);
    }

    public static <A, B, C> F2<NonEmptyList<A>, NonEmptyList<B>, NonEmptyList<C>> zipNelM(F2<A, B, C> f) {
        return (as, bs) -> NonEmptyList.fromList(as.toList().zipWith(bs.toList(), f)).some();
    }

    public static <A, B, C> F2<Set<A>, Set<B>, Set<C>> zipSetM(F2<A, B, C> f, Ord<C> o) {
        return (as, bs) -> Set.iterableSet(o, as.toStream().zipWith(bs.toStream(), f));
    }

    public static <A, B, C> F2<Tree<A>, Tree<B>, Tree<C>> zipTreeM(final F2<A, B, C> f) {
        return new F2<Tree<A>, Tree<B>, Tree<C>>(){

            @Override
            public Tree<C> f(Tree<A> ta, Tree<B> tb) {
                2 self = this;
                return Tree.node(f.f(ta.root(), tb.root()), P.lazy(() -> F2Functions.zipStreamM(self).f(ta.subForest()._1(), tb.subForest()._1())));
            }
        };
    }

    public static <A, B, C> F2<Zipper<A>, Zipper<B>, Zipper<C>> zipZipperM(F2<A, B, C> f) {
        return (ta, tb) -> {
            F2 sf = F2Functions.zipStreamM(f);
            return Zipper.zipper(sf.f(ta.lefts(), tb.lefts()), f.f(ta.focus(), tb.focus()), sf.f(ta.rights(), tb.rights()));
        };
    }

    public static <A, B, C> F2<TreeZipper<A>, TreeZipper<B>, TreeZipper<C>> zipTreeZipperM(F2<A, B, C> f) {
        return (ta, tb) -> {
            F2 sf = F2Functions.zipStreamM(F2Functions.treeM(f));
            F2<Stream<P3>, Stream<P3>, Stream<P3>> pf = F2Functions.zipStreamM((pa, pb) -> P.p(F2Functions.zipStreamM(F2Functions.treeM(f)).f(pa._1(), pb._1()), f.f(pa._2(), pb._2()), F2Functions.zipStreamM(F2Functions.treeM(f)).f(pa._3(), pb._3())));
            return TreeZipper.treeZipper(F2Functions.treeM(f).f(ta.p()._1(), tb.p()._1()), sf.f(ta.lefts(), tb.lefts()), sf.f(ta.rights(), tb.rights()), pf.f(ta.p()._4(), tb.p()._4()));
        };
    }

    public static <A, B, C, Z> F2<Z, B, C> contramapFirst(F2<A, B, C> target, F<Z, A> f) {
        return (z, b) -> target.f(f.f(z), b);
    }

    public static <A, B, C, Z> F2<A, Z, C> contramapSecond(F2<A, B, C> target, F<Z, B> f) {
        return (a, z) -> target.f(a, f.f(z));
    }

    public static <A, B, C, X, Y> F2<X, Y, C> contramap(F2<A, B, C> target, F<X, A> f, F<Y, B> g) {
        return F2Functions.contramapSecond(F2Functions.contramapFirst(target, f), g);
    }

    public static <A, B, C, Z> F2<A, B, Z> map(F2<A, B, C> target, F<C, Z> f) {
        return (a, b) -> f.f(target.f(a, b));
    }
}

