/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.xml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAXUtils {
    private static final Logger log = LoggerFactory.getLogger(SAXUtils.class);
    private static final Map<String, Boolean> NO_FEATURES = new HashMap<String, Boolean>();

    private SAXUtils() {
    }

    public static SAXParserFactory newSafeFactory(Map<String, Boolean> features) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            for (Map.Entry<String, Boolean> entry : features.entrySet()) {
                log.trace("set feature {} -> {}", (Object)entry.getKey(), (Object)entry.getValue());
                factory.setFeature(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            throw ConfigRuntimeException.convertExMethod((String)"newFactory", (Exception)e);
        }
        return factory;
    }

    public static SAXParserFactory newSafeFactory() {
        return SAXUtils.newSafeFactory(NO_FEATURES);
    }
}

