/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.xml;

import java.io.Reader;
import javax.xml.parsers.SAXParser;
import org.fugerit.java.core.xml.sax.SAXParseResult;
import org.fugerit.java.core.xml.sax.XMLFactorySAX;
import org.fugerit.java.core.xml.sax.dh.DefaultHandlerComp;
import org.fugerit.java.doc.base.config.DocException;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.model.DocHelper;
import org.fugerit.java.doc.base.parser.AbstractDocParser;
import org.fugerit.java.doc.base.parser.DocValidationResult;
import org.fugerit.java.doc.base.xml.DocContentHandler;
import org.fugerit.java.doc.base.xml.DocValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DocXmlParser
extends AbstractDocParser {
    private static final Logger log = LoggerFactory.getLogger(DocXmlParser.class);
    private DocHelper docHelper;

    public DocXmlParser(DocHelper docHelper) {
        super(1);
        this.docHelper = docHelper;
    }

    public DocXmlParser() {
        this(DocHelper.DEFAULT);
    }

    @Override
    protected DocBase parseWorker(Reader reader) throws DocException {
        DocContentHandler dch = new DocContentHandler(this.docHelper);
        try {
            SAXParser parser = XMLFactorySAX.makeSAXParser((boolean)false, (boolean)true);
            DefaultHandlerComp dh = new DefaultHandlerComp((ContentHandler)dch);
            parser.parse(new InputSource(reader), (DefaultHandler)dh);
        }
        catch (Exception e) {
            throw DocException.convertExMethod("parseWorker", e);
        }
        return dch.getDocBase();
    }

    @Override
    protected DocValidationResult validateWorker(Reader reader, boolean parseVersion) throws DocException {
        DocValidationResult docResult = DocValidationResult.newDefaultNotDefinedResult();
        SAXParseResult result = null;
        try {
            result = parseVersion ? DocValidator.validateVersion(reader) : DocValidator.validate(reader);
        }
        catch (Exception e) {
            throw DocException.convertExMethod("validateWorker", e);
        }
        for (Exception e : result.fatalsAndErrors()) {
            docResult.getErrorList().add(e.toString());
        }
        for (Exception e : result.warnings()) {
            docResult.getInfoList().add(e.toString());
        }
        docResult.evaluateResult();
        log.debug("Validation result {}", (Object)docResult);
        return docResult;
    }
}

