/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.xml;

import java.util.Properties;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.model.DocHelper;
import org.fugerit.java.doc.base.parser.DocParserContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DocContentHandler
implements ContentHandler {
    private DocParserContext context;
    private DocHelper docHelper;

    public static Properties attsToProperties(Attributes atts) {
        Properties props = new Properties();
        for (int k = 0; k < atts.getLength(); ++k) {
            String key = atts.getQName(k);
            String value = atts.getValue(k);
            props.setProperty(key, value);
        }
        return props;
    }

    public DocContentHandler(DocHelper docHelper) {
        this.docHelper = docHelper;
        this.context = new DocParserContext();
    }

    public DocContentHandler() {
        this(new DocHelper());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String text = this.docHelper.filterText(new String(ch, start, length));
        this.context.handleText(text);
    }

    @Override
    public void endDocument() throws SAXException {
        this.context.endDocument();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.context.startDocument();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.context.handleEndElement(qName);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Properties props = DocContentHandler.attsToProperties(atts);
        this.context.handleStartElement(qName, props);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public DocBase getDocBase() {
        return this.context.getDocBase();
    }
}

