/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.typehelper.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.fugerit.java.core.io.helper.HelperIOException;
import org.fugerit.java.core.io.helper.StreamHelper;
import org.fugerit.java.doc.base.model.DocBase;

public class ExcelHelperUtils {
    private ExcelHelperUtils() {
    }

    public static InputStream resoveTemplateStream(DocBase docBase) throws IOException {
        String excelTemplate = docBase.getInfo().getProperty("excel-template");
        InputStream is = null;
        if (excelTemplate != null) {
            try {
                is = StreamHelper.resolveStream((String)excelTemplate);
                if (is == null) {
                    throw new IOException("Cannot find template at path : " + excelTemplate);
                }
            }
            catch (Exception e) {
                throw HelperIOException.convertExMethod((String)"resoveTemplateStream", (Exception)e);
            }
        }
        return is;
    }

    public static String convertComma(String s) {
        int index = s.indexOf(44);
        if (index != -1) {
            s = s.substring(0, index) + "." + s.substring(index + 1);
        }
        return s;
    }

    public static String removeDots(String s) {
        StringBuilder r = new StringBuilder();
        StringTokenizer st = new StringTokenizer(s, ".");
        while (st.hasMoreTokens()) {
            r.append(st.nextToken());
        }
        return r.toString();
    }

    public static String prepareNumber(String s) {
        s = ExcelHelperUtils.removeDots(s);
        s = ExcelHelperUtils.convertComma(s);
        return s;
    }
}

