/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.typehandler.markdown;

import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import org.fugerit.java.doc.base.helper.DocTypeFacadeDefault;
import org.fugerit.java.doc.base.helper.DocTypeFacadeHelper;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.model.DocCell;
import org.fugerit.java.doc.base.model.DocContainer;
import org.fugerit.java.doc.base.model.DocElement;
import org.fugerit.java.doc.base.model.DocLi;
import org.fugerit.java.doc.base.model.DocList;
import org.fugerit.java.doc.base.model.DocPara;
import org.fugerit.java.doc.base.model.DocPhrase;
import org.fugerit.java.doc.base.model.DocRow;
import org.fugerit.java.doc.base.model.DocTable;
import org.fugerit.java.doc.base.model.util.DocTableUtil;

public class MarkdownBasicDocFacade
extends DocTypeFacadeDefault {
    private static final long serialVersionUID = -3183772778800073010L;
    private PrintWriter writer;
    private boolean printComments;
    public static final boolean DEFAULT_PRINT_COMMENTS = true;

    protected PrintWriter getWriter() {
        return this.writer;
    }

    public MarkdownBasicDocFacade(PrintWriter writer) {
        this(writer, true);
    }

    public MarkdownBasicDocFacade(PrintWriter writer, boolean printComments) {
        this.writer = writer;
        this.printComments = printComments;
    }

    @Override
    public void handleDoc(DocBase docBase) throws Exception {
        if (this.printComments) {
            this.getWriter().print("[//]: # (generator : ");
            this.getWriter().print(this.getClass().getName());
            this.getWriter().println(" )");
            this.getWriter().print("[//]: # (generated on ");
            this.getWriter().print(new Date());
            this.getWriter().println(" )  ");
            this.getWriter().println();
        }
        DocTypeFacadeHelper helper = new DocTypeFacadeHelper(docBase);
        this.handleElements(docBase.getDocBody(), helper);
        this.getWriter().flush();
    }

    private void addStyle(int textStyle) {
        if (textStyle == 2 || textStyle == 5) {
            this.writer.print("**");
        } else if (textStyle == 4) {
            this.writer.print("*");
        }
    }

    private void handleText(String text, int textStyle) throws Exception {
        this.addStyle(textStyle);
        this.writer.print(text);
        this.addStyle(textStyle);
    }

    @Override
    public void handlePara(DocPara docPara, DocContainer parent, DocTypeFacadeHelper helper) throws Exception {
        boolean body = helper.getDepth() == 0;
        for (int headLevel = docPara.getHeadLevel(); headLevel > 0; --headLevel) {
            this.writer.print("#");
        }
        if (docPara.getHeadLevel() > 0) {
            this.writer.print(" ");
        }
        this.handleText(docPara.getText(), docPara.getStyle());
        if (body) {
            this.writer.println("  ");
        } else {
            this.writer.print(" ");
        }
    }

    @Override
    public void handlePhrase(DocPhrase docPhrase, DocContainer parent, DocTypeFacadeHelper helper) throws Exception {
        this.handleText(docPhrase.getText(), docPhrase.getStyle());
        this.writer.print(" ");
    }

    @Override
    public void handleList(DocList docList, DocContainer parent, DocTypeFacadeHelper helper) throws Exception {
        this.getWriter().println();
        for (DocElement liEl : docList.getElementList()) {
            if (!(liEl instanceof DocLi)) continue;
            DocLi li = (DocLi)liEl;
            this.getWriter().print("* ");
            this.handleElements(li, helper);
            this.getWriter().println();
        }
    }

    @Override
    public void handleTable(DocTable docTable, DocContainer parent, DocTypeFacadeHelper helper) throws Exception {
        this.getWriter().println();
        this.getWriter().println("<table>");
        this.handleDocUtilTable(docTable, parent, helper);
        this.getWriter().println("<table>");
    }

    protected void handleDocUtilTable(DocTable table, DocContainer parent, DocTypeFacadeHelper helper) throws Exception {
        DocTableUtil tableUtil = new DocTableUtil(table);
        this.handleRowList(table, tableUtil, tableUtil.getHeaderRows(), true, helper);
        this.handleRowList(table, tableUtil, tableUtil.getDataRows(), false, helper);
    }

    protected void handleRowList(DocTable table, DocTableUtil tableUtil, List<DocElement> rowList, boolean header, DocTypeFacadeHelper helper) throws Exception {
        String cellType = "td";
        if (header) {
            cellType = "th";
        }
        for (DocElement element : rowList) {
            DocRow row = (DocRow)element;
            this.getWriter().println("<tr>");
            for (DocElement cellEl : row.getElementList()) {
                DocCell cell = (DocCell)cellEl;
                this.getWriter().print("<");
                this.getWriter().print(cellType);
                this.getWriter().print(">");
                this.handleElements(cell, helper);
                this.getWriter().print("</");
                this.getWriter().print(cellType);
                this.getWriter().println(">");
            }
            this.getWriter().println("</tr>");
        }
    }
}

