/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.model;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.fugerit.java.doc.base.model.DocBackground;
import org.fugerit.java.doc.base.model.DocBookmarkTree;
import org.fugerit.java.doc.base.model.DocContainer;
import org.fugerit.java.doc.base.model.DocElement;
import org.fugerit.java.doc.base.model.DocFooter;
import org.fugerit.java.doc.base.model.DocHeader;
import org.fugerit.java.doc.base.model.DocInfo;

public class DocBase
extends DocElement
implements Serializable {
    private static final long serialVersionUID = 80026421125892032L;
    public static final String TAG_NAME = "doc";
    private DocHeader docHeader;
    private DocFooter docFooter;
    private DocContainer docBody = new DocContainer();
    private DocContainer docMeta = new DocContainer();
    private DocBackground docBackground;
    private DocBookmarkTree docBookmarkTree;
    private HashMap<String, DocElement> idMap;
    private String xsdVersion;
    private Properties stableInfo;

    private static void print(DocContainer docContainer, PrintStream s, int pad) {
        StringBuilder builder = new StringBuilder();
        for (int k = 0; k < pad; ++k) {
            builder.append("  ");
        }
        Iterator<DocElement> it = docContainer.docElements();
        String p = builder.toString();
        while (it.hasNext()) {
            DocElement docElement = it.next();
            s.println(p + docElement);
            if (!(docElement instanceof DocContainer)) continue;
            DocBase.print((DocContainer)docElement, s, pad + 1);
        }
    }

    public static void print(DocBase docBase, PrintStream s) {
        s.println(docBase);
        DocBase.print(docBase.getDocBody(), s, 1);
    }

    public DocBase() {
        this.docHeader = new DocHeader();
        this.docFooter = new DocFooter();
        this.idMap = new HashMap();
    }

    public String getXsdVersion() {
        return this.xsdVersion;
    }

    public void setXsdVersion(String xsdVersion) {
        this.xsdVersion = xsdVersion;
    }

    public void setId(String id, DocElement element) {
        element.setId(id);
        this.idMap.put(id, element);
    }

    public DocElement getElementById(String id) {
        return this.idMap.get(id);
    }

    public Properties getInfo() {
        Properties info = new Properties();
        Iterator<DocElement> itInfo = this.getDocMeta().docElements();
        while (itInfo.hasNext()) {
            DocElement docElement = itInfo.next();
            if (!(docElement instanceof DocInfo)) continue;
            DocInfo docInfo = (DocInfo)docElement;
            info.setProperty(docInfo.getName(), docInfo.getContent().toString());
        }
        return info;
    }

    public Properties getStableInfo() {
        return this.stableInfo;
    }

    public void setStableInfo(Properties stableInfo) {
        this.stableInfo = stableInfo;
    }

    public String getInfoPageWidth() {
        return this.getStableInfo().getProperty("page-width");
    }

    public String getInfoPageHeight() {
        return this.getStableInfo().getProperty("page-height");
    }

    public String getInfoDocVersion() {
        return this.getStableInfo().getProperty("doc-version");
    }

    public String getInfoDocTitle() {
        return this.getStableInfo().getProperty("doc-title");
    }

    public String getInfoDocSubject() {
        return this.getStableInfo().getProperty("doc-subject");
    }

    public String getInfoDocAuthor() {
        return this.getStableInfo().getProperty("doc-author");
    }

    public String getInfoDocCreator() {
        return this.getStableInfo().getProperty("doc-creator");
    }

    public String getInfoDocLanguage() {
        return this.getStableInfo().getProperty("doc-language");
    }

    private static int getMargin(Properties props, int position) {
        String margins = props.getProperty("margins", "10;10;10;10");
        return Integer.parseInt(margins.split(";")[position]);
    }

    public int getMarginLeft() {
        return DocBase.getMargin(this.getInfo(), 0);
    }

    public int getMarginRight() {
        return DocBase.getMargin(this.getInfo(), 1);
    }

    public int getMarginTop() {
        return DocBase.getMargin(this.getInfo(), 2);
    }

    public int getMarginBottom() {
        return DocBase.getMargin(this.getInfo(), 3);
    }

    public boolean isUseHeader() {
        return this.getDocHeader() != null && this.getDocHeader().isUseHeader();
    }

    public boolean isUseFooter() {
        return this.getDocFooter() != null && this.getDocFooter().isUseFooter();
    }

    public DocHeader getDocHeader() {
        return this.docHeader;
    }

    public void setDocHeader(DocHeader docHeader) {
        this.docHeader = docHeader;
    }

    public DocFooter getDocFooter() {
        return this.docFooter;
    }

    public void setDocFooter(DocFooter docFooter) {
        this.docFooter = docFooter;
    }

    public DocContainer getDocBody() {
        return this.docBody;
    }

    public void setDocBody(DocContainer docBody) {
        this.docBody = docBody;
    }

    public DocContainer getDocMeta() {
        return this.docMeta;
    }

    public void setDocMeta(DocContainer docMeta) {
        this.docMeta = docMeta;
    }

    public DocBackground getDocBackground() {
        return this.docBackground;
    }

    public void setDocBackground(DocBackground docBackground) {
        this.docBackground = docBackground;
    }

    public DocBookmarkTree getDocBookmarkTree() {
        return this.docBookmarkTree;
    }

    public void setDocBookmarkTree(DocBookmarkTree docBookmarkTree) {
        this.docBookmarkTree = docBookmarkTree;
    }
}

