/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.helper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.fugerit.java.core.io.StreamIO;
import org.fugerit.java.core.io.helper.StreamHelper;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.doc.base.helper.Base64Helper;
import org.fugerit.java.doc.base.model.DocImage;

public class SourceResolverHelper {
    public static final String MODE_CLASSLOADER = "cl://";

    private SourceResolverHelper() {
    }

    public static String resolveImageToBase64(DocImage img) throws IOException {
        String path = img.getUrl();
        String base64 = img.getBase64();
        if (StringUtils.isEmpty((String)base64) && path != null) {
            try {
                byte[] data = null;
                if (path.startsWith(MODE_CLASSLOADER)) {
                    data = StreamIO.readBytes((InputStream)StreamHelper.resolveStream((String)path));
                } else {
                    URL url = new URL(path);
                    data = StreamIO.readBytes((InputStream)url.openConnection().getInputStream());
                }
                base64 = Base64Helper.encodeBase64String(data);
            }
            catch (Exception e) {
                throw new IOException("Errore on resolveImageToBase64 : " + e, e);
            }
        } else {
            throw new IOException("Null path and base64 provided!");
        }
        return base64;
    }

    public static byte[] resolveImage(DocImage img) throws IOException {
        byte[] data = null;
        String path = img.getUrl();
        String base64 = img.getBase64();
        if (StringUtils.isNotEmpty((String)base64)) {
            data = Base64Helper.decodeBase64String(base64);
        } else if (path != null) {
            try {
                if (path.startsWith(MODE_CLASSLOADER)) {
                    data = StreamIO.readBytes((InputStream)StreamHelper.resolveStream((String)path));
                }
                URL url = new URL(path);
                data = StreamIO.readBytes((InputStream)url.openConnection().getInputStream());
            }
            catch (Exception e) {
                throw new IOException("Errore on resolveImage : " + e, e);
            }
        } else {
            throw new IOException("Null path provided!");
        }
        return data;
    }
}

