/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.facade;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import org.fugerit.java.core.cfg.xml.FactoryCatalog;
import org.fugerit.java.core.cfg.xml.FactoryType;
import org.fugerit.java.core.cfg.xml.FactoryTypeHelper;
import org.fugerit.java.core.io.helper.StreamHelper;
import org.fugerit.java.doc.base.config.DocTypeHandler;
import org.fugerit.java.doc.base.facade.DocHandlerFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocHandlerFactory
extends HashMap<String, DocHandlerFacade> {
    private static final long serialVersionUID = 4879476159814004578L;
    public static final String USE_CATALOG_PROP = "user-catalog";
    private String useCatalog;
    private static final Logger logger = LoggerFactory.getLogger(DocHandlerFactory.class);
    private static final FactoryTypeHelper<DocTypeHandler> HELPER = FactoryTypeHelper.newInstance(DocTypeHandler.class);

    public static DocHandlerFacade register(String factoryCatalogPath) throws Exception {
        return DocHandlerFactory.register(factoryCatalogPath, null);
    }

    public static DocHandlerFacade register(String factoryCatalogPath, String useFactory) throws Exception {
        DocHandlerFacade facade = null;
        try (InputStream is = StreamHelper.resolveStream((String)factoryCatalogPath);){
            FactoryCatalog catalog = new FactoryCatalog();
            catalog.configureXML(is);
            facade = DocHandlerFactory.register(catalog, useFactory);
        }
        return facade;
    }

    public static DocHandlerFacade register(Collection<FactoryType> col) throws Exception {
        DocHandlerFacade facade = null;
        if (col != null) {
            facade = new DocHandlerFacade();
            for (FactoryType ft : col) {
                DocTypeHandler handler = (DocTypeHandler)HELPER.createHelper(ft);
                if (handler != null) {
                    facade.registerHandler(handler);
                    continue;
                }
                logger.info("skipped null handler for -> {}", (Object)ft);
            }
        }
        return facade;
    }

    public static DocHandlerFacade register(FactoryCatalog catalog) throws Exception {
        return DocHandlerFactory.register(catalog, null);
    }

    public static DocHandlerFacade register(FactoryCatalog catalog, String useFactory) throws Exception {
        DocHandlerFacade facade = null;
        String useCatalog = useFactory;
        if (useCatalog == null) {
            useCatalog = catalog.getGeneralProps().getProperty(USE_CATALOG_PROP);
        }
        if (useCatalog != null) {
            Collection col = catalog.getDataList(useCatalog);
            facade = DocHandlerFactory.register(col);
        }
        return facade;
    }

    public static DocHandlerFactory newInstance(InputStream factoryConfig) throws Exception {
        FactoryCatalog catalog = new FactoryCatalog();
        catalog.configureXML(factoryConfig);
        return DocHandlerFactory.newInstance(catalog);
    }

    public static DocHandlerFactory newInstance(String factoryCatalogPath) throws Exception {
        DocHandlerFactory map = null;
        try (InputStream is = StreamHelper.resolveStream((String)factoryCatalogPath);){
            map = DocHandlerFactory.newInstance(is);
        }
        return map;
    }

    public static DocHandlerFactory newInstance(FactoryCatalog catalog) throws Exception {
        DocHandlerFactory map = new DocHandlerFactory(catalog.getGeneralProps().getProperty(USE_CATALOG_PROP));
        for (String id : catalog.getIdSet()) {
            Collection col = catalog.getDataList(id);
            DocHandlerFacade facade = DocHandlerFactory.register(col);
            map.put(id, facade);
        }
        return map;
    }

    private DocHandlerFactory(String useCatalog) {
        this.useCatalog = useCatalog;
    }

    public String getUseCatalog() {
        return this.useCatalog;
    }
}

