/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.config;

import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.lang.helpers.ClassHelper;
import org.fugerit.java.core.util.checkpoint.CheckpointUtils;
import org.fugerit.java.doc.base.config.DocInput;
import org.fugerit.java.doc.base.config.DocOutput;
import org.fugerit.java.doc.base.config.DocTypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitHandler {
    private static final Logger log = LoggerFactory.getLogger(InitHandler.class);
    public static final String PATH_INIT_DOC = "config/init_doc/doc-init.xml";

    private InitHandler() {
    }

    public static boolean initDoc(DocTypeHandler handler) throws ConfigException {
        boolean init = true;
        long startTime = System.currentTimeMillis();
        try (InputStreamReader reader = new InputStreamReader(ClassHelper.loadFromDefaultClassLoader((String)PATH_INIT_DOC));
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            handler.handle(DocInput.newInput(handler.getType(), reader), DocOutput.newOutput(baos));
            log.info("Init handler time {} -> {}", (Object)handler, (Object)CheckpointUtils.formatTimeDiffMillis((long)startTime, (long)System.currentTimeMillis()));
        }
        catch (Exception e) {
            throw new ConfigException("Init exception : " + e, (Throwable)e);
        }
        return init;
    }

    public static void initDocAsync(final DocTypeHandler handler) {
        Runnable runInitDoc = new Runnable(){

            @Override
            public void run() {
                log.info("Init handler start : {}", (Object)handler);
                try {
                    boolean initOk = InitHandler.initDoc(handler);
                    log.info("Init handler end : {} -> {}", (Object)handler, (Object)initOk);
                }
                catch (ConfigException e) {
                    log.info("Init handler error " + (Object)((Object)e), (Throwable)e);
                }
            }
        };
        Thread t = new Thread(runInitDoc);
        t.start();
    }
}

