/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.config;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Properties;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.cfg.ConfigurableObject;
import org.fugerit.java.core.cfg.helpers.XMLConfigurableObject;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.core.xml.dom.DOMIO;
import org.fugerit.java.doc.base.config.DocCharsetProvider;
import org.fugerit.java.doc.base.config.DocInput;
import org.fugerit.java.doc.base.config.DocOutput;
import org.fugerit.java.doc.base.config.DocTypeHandler;
import org.fugerit.java.doc.base.helper.DefaultMimeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DocTypeHandlerDefault
implements DocTypeHandler,
ConfigurableObject,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(DocTypeHandlerDefault.class);
    private static final long serialVersionUID = -5024985828785381015L;
    public static final String TAG_NAME_CONFIG = "config";
    public static final String TAG_NAME_CONFIG_ALT = "docHandlerCustomConfig";
    public static final String ATT_NAME_CHARSET = "charset";
    private String type;
    private String module;
    private String mime;
    private String format;
    private transient Charset charset;

    public void configureProperties(InputStream source) throws ConfigException {
        XMLConfigurableObject.DO_NOTHING.configureProperties(source);
    }

    public void configureXML(InputStream source) throws ConfigException {
        try {
            this.configure(DOMIO.loadDOMDoc((InputStream)source).getDocumentElement());
        }
        catch (Exception e) {
            throw new ConfigException((Throwable)e);
        }
    }

    public void configure(Properties props) throws ConfigException {
        XMLConfigurableObject.DO_NOTHING.configure(props);
    }

    @Override
    public String getMime() {
        String res = this.mime;
        if (res == null) {
            res = DefaultMimeHelper.getDefaultMime(this.getType());
        }
        return res;
    }

    public String getKey() {
        return DocTypeHandlerDefault.createKey(this.getFormat(), this.getModule());
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public String getFormat() {
        return StringUtils.valueWithDefault((String)this.format, (String)this.getType());
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void handle(DocInput docInput, DocOutput docOutput) throws Exception {
    }

    public DocTypeHandlerDefault(String type, String module, String mime, Charset charset) {
        this(type, module, mime, charset, null);
    }

    public DocTypeHandlerDefault(String type, String module, String mime, Charset charset, String format) {
        this.type = type;
        this.module = module;
        this.mime = mime;
        this.format = format;
        this.charset = DocCharsetProvider.getDefaultProvider().resolveCharset(charset);
    }

    public DocTypeHandlerDefault(String type, String module, String mime) {
        this(type, module, mime, null);
    }

    public DocTypeHandlerDefault(String type, String module) {
        this(type, module, null);
    }

    public static final String createKey(String type, String mod) {
        return type + "-" + mod;
    }

    protected void handleConfigTag(Element config) throws ConfigException {
    }

    private Element lookupConfig(Element tag, String tagName) {
        String charsetAtt;
        Element configTag = null;
        NodeList nl = tag.getElementsByTagName(tagName);
        if (nl.getLength() > 0 && StringUtils.isNotEmpty((String)(charsetAtt = (configTag = (Element)nl.item(0)).getAttribute(ATT_NAME_CHARSET)))) {
            this.charset = Charset.forName(charsetAtt);
        }
        return configTag;
    }

    public void configure(Element tag) throws ConfigException {
        log.info("configure : {}", (Object)tag.getAttribute("id"));
        Element configTag = this.lookupConfig(tag, TAG_NAME_CONFIG_ALT);
        if (configTag == null) {
            configTag = this.lookupConfig(tag, TAG_NAME_CONFIG);
        }
        if (configTag != null) {
            this.handleConfigTag(configTag);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [type=" + this.type + ", module=" + this.module + ", format=" + this.format + "]";
    }

    protected void setFormat(String format) {
        this.format = format;
    }
}

