/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.config;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.fugerit.java.core.util.ObjectUtils;

public abstract class DocCharsetProvider {
    public static final DocCharsetProvider DEFAULT = DocCharsetProvider.newProvider(Charset.defaultCharset());
    public static final DocCharsetProvider DEFAULT_TO_UTF8 = DocCharsetProvider.newProvider(StandardCharsets.UTF_8);
    private static DocCharsetProvider defaultProvider = DEFAULT;

    public abstract Charset resolveCharset(Charset var1);

    public static DocCharsetProvider getDefaultProvider() {
        return defaultProvider;
    }

    public static void setDefaultProvider(DocCharsetProvider defaultProvider) {
        DocCharsetProvider.defaultProvider = defaultProvider;
    }

    public static DocCharsetProvider newProvider(final Charset useDefault) {
        return new DocCharsetProvider(){

            @Override
            public Charset resolveCharset(Charset charset) {
                return (Charset)ObjectUtils.objectWithDefault((Object)charset, (Object)useDefault);
            }
        };
    }
}

