/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.netconfig;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.friendularity.bundle.netconfig.NetworkConfig;
import org.friendularity.bundle.netconfig.NetworkConfigurator;
import org.friendularity.bundle.netconfig.WiFiSecurity;

public class LinuxNetworkConfigurator
implements NetworkConfigurator {
    private static final Logger theLogger = Logger.getLogger(LinuxNetworkConfigurator.class.getName());

    @Override
    public void configureNetwork(NetworkConfig config) {
        Map<String, Map<String, String>> confMap = this.createMap(config);
        String confData = this.makeConfFile(confMap);
        this.writeConfig(confData, "/home/fit/nm_conf");
        this.restartServices();
    }

    private Map<String, Map<String, String>> createMap(NetworkConfig config) {
        HashMap<String, Map<String, String>> confMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> connectionMap = new HashMap<String, String>();
        HashMap<String, String> wirelessMap = new HashMap<String, String>();
        HashMap<String, String> ipv4Map = new HashMap<String, String>();
        HashMap<String, String> ipv6Map = new HashMap<String, String>();
        confMap.put("connection", connectionMap);
        confMap.put("802-11-wireless", wirelessMap);
        confMap.put("ipv4", ipv4Map);
        confMap.put("ipv6", ipv6Map);
        connectionMap.put("type", "802-11-wireless");
        connectionMap.put("id", "nm_conf");
        connectionMap.put("autoconnect", "true");
        wirelessMap.put("mode", "infrastructure");
        wirelessMap.put("ssid", this.makeSsid(config.getSsid()));
        ipv4Map.put("method", "auto");
        ipv6Map.put("method", "ignore");
        if (config.getSecurity() != WiFiSecurity.NONE) {
            HashMap<String, String> securityMap = new HashMap<String, String>();
            confMap.put("802-11-wireless-security", securityMap);
            wirelessMap.put("security", "802-11-wireless-security");
            if (config.getSecurity() == WiFiSecurity.WPA) {
                securityMap.put("key-mgmt", "wpa-psk");
                securityMap.put("psk", config.getKey());
            } else if (config.getSecurity() == WiFiSecurity.WEP) {
                securityMap.put("key-mgmt", "none");
                securityMap.put("wep-tx-keyidx", "0");
                securityMap.put("auth-alg", "open");
                securityMap.put("wep-key0", config.getKey());
                securityMap.put("wep-key-type", "1");
            }
        }
        return confMap;
    }

    private String makeSsid(String textSsid) {
        StringBuilder ssid = new StringBuilder();
        for (char i : textSsid.toCharArray()) {
            ssid.append((int)i).append(";");
        }
        return ssid.toString();
    }

    private String makeConfFile(Map<String, Map<String, String>> confMap) {
        StringBuilder confData = new StringBuilder();
        for (String i : confMap.keySet()) {
            Map<String, String> sectionMap = confMap.get(i);
            confData.append("[").append(i).append("]\n");
            for (String j : sectionMap.keySet()) {
                String k = sectionMap.get(j);
                confData.append(j).append("=").append(k).append("\n");
            }
            confData.append("\n");
        }
        return confData.toString();
    }

    private void writeConfig(String confData, String fileName) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(confData);
            writer.close();
        }
        catch (Exception e) {
            theLogger.log(Level.SEVERE, "Failed to write to file {0}", fileName);
        }
    }

    private void restartServices() {
        this.runCommand("sudo /usr/robokind/launch/nmrestart.sh");
    }

    private int runCommand(String cmd) {
        try {
            Process command = Runtime.getRuntime().exec(cmd);
            int retVal = command.waitFor();
            return retVal;
        }
        catch (Exception e) {
            theLogger.log(Level.SEVERE, "Failed to run {0}", cmd);
            return 1;
        }
    }
}

