/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;

class DirectBufferPool {
    static final DirectBufferPool __instance = new DirectBufferPool();
    public static final int MIN_BUFFER_SIZE = 110016;
    private static final int DEFAULT_NUM_BUFFERS = 128;
    private static final int DEFAULT_BUFFER_SIZE = 524288;
    private ArrayBlockingQueue<ByteBuffer> buffers;
    private int currentBufferCapacity;

    public DirectBufferPool() {
        this.resize(128, 524288);
    }

    public static DirectBufferPool getInstance() {
        return __instance;
    }

    public synchronized void resize(int n, int n2) {
        if (n2 < 110016) {
            throw new IllegalArgumentException("'bufferSize' must be at-least: 110016 bytes");
        }
        this.buffers = new ArrayBlockingQueue(n);
        this.currentBufferCapacity = n2;
        while (this.buffers.size() < n) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
            this.buffers.add(byteBuffer);
        }
    }

    public synchronized ByteBuffer poll() {
        return this.buffers.poll();
    }

    public synchronized void add(ByteBuffer byteBuffer) {
        if (byteBuffer.capacity() != this.currentBufferCapacity) {
            return;
        }
        this.buffers.offer(byteBuffer);
    }
}

